package com.js.web.controller.swagger;

import com.js.common.constant.Constant;
import com.js.common.model.req.JsLoanRiskInfoReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsLoanRiskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author zhouyongsheng
 * @Description 贷款准入
 * @Date 2019/6/1
 **/
@Api(value="贷款准入",tags="贷款准入")
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsLoanRiskSwaggerController {

    @Autowired
    private JsLoanRiskService jsLoanRiskService;

    @Autowired
    JsKycNaturalService jsKycNaturalService;
    /**
     * 贷款准入
     * @return
     */
    @ApiOperation(value="贷款准入",notes="贷款准入")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loan/risk",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage loanRisk(@Valid @RequestBody JsLoanRiskInfoReq jsLoanRiskInfoReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
//        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
//        jsLoanRiskInfoReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
//        jsLoanRiskInfoReq.setRegisterType(optionalKycNaturalVO.get().getRegisterType());
        return jsLoanRiskService.loanRisk(jsLoanRiskInfoReq);
    }
}
