package com.js.web.controller.pay;


import com.js.common.constant.Constant;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.EnterpriseInfoService;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Optional;


/**
 * 向收款系统提供企业相关信息
 * @Date 2019-08-15
 * @author liuh
 */
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsPayEnterpriseInfoController {
    @Autowired
    EnterpriseInfoService enterpriseInfoService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsPayEnterpriseInfo/getEnterprise25Partners")
    public ResponseMessage getEnterprise25Partners(String kycCertiId,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return enterpriseInfoService.getEnterprise25Partners(optionalKycNaturalVO.get(),kycCertiId);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsPayEnterpriseInfo/getEnterprisePartners")
    public ResponseMessage getEnterprisePartners2(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return enterpriseInfoService.getEnterprisePartners2(optionalKycNaturalVO.get());
    }
}
