package com.js.web.controller.loan;

import com.js.common.constant.Constant;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.mq.RabbitMQSender;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author liuxin
 * @Description rabbitMq测试controller
 * @Date 2019/5/18
 * @Param
 * @return
 **/
@Slf4j
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class MqTestController {

    @Autowired
    private RabbitMQSender rabbitMQSender;

    /**
     *  测试mq接收和发送
     * @param type  字典类型
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/test/sendmq")
    public ResponseMessage findDictionary(@RequestParam(value = "testId",required = false) String testId,
                                          @RequestParam(value = "testId2",required = false) String testId2) {
        log.info(testId);
        rabbitMQSender.testSender(testId,testId2);

        return null;
    }
}
