package com.js.web.validate.code.email;

import com.js.common.model.req.ValidateCodeReq;
import com.js.web.service.IMailService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

/**
 * @Author liuh
 * @Description 发送邮箱验证码
 * @Date 2019/8/4
 **/
@Slf4j
public class DefaultEmailCodeSender implements EmailCodeSender {

    @Autowired
    private IMailService iMailService;
    @Value("${js.file.path}")
    private String templateFilePath;

    @Override
    public void send(ValidateCodeReq validateCodeReq, String code) {
        log.warn("邮箱验证码发送器(EmailCodeSender)");
        try {
            StringBuffer sb = new StringBuffer("<p style=\"margin: 0;line-height: 24px;font-size: 14px;\">您正在进行邮箱绑定，邮箱验证码为：<span style=\"font-size:16px;font-weight: bold;color: #3d86e9;\">")
            .append(code)
            .append("</span></p >")
            .append("<p style=\"margin: 0 0 40px;line-height: 24px;font-size: 14px;\">验证码有有效期为15分钟，请勿将验证码泄露于他人。</p >");
            iMailService.sendTemplateHtmlMail(validateCodeReq.getEmailAdd(),"绑定邮箱验证", sb.toString(),validateCodeReq.getPhoneNo());
        }catch (Exception ex){
            ex.printStackTrace();
        }
        String rtnCode = "";
        log.info("向邮箱:{}, 发送验证码:{}, 返回:{}" ,validateCodeReq.getEmailAdd() ,code ,rtnCode);
    }
}
