package com.js.web.validate.code;

import com.js.common.model.req.ValidateCodeReq;
import com.js.common.model.vo.ValidateCodeVO;
import org.springframework.web.context.request.ServletWebRequest;

import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

/**
 * 验证码处理器，封装不同的验证码处理逻辑
 */
public interface ValidateCodeProcessor {

    /**
     * 创建校验码
     *
     * @param response
     * @param validateCodeReq
     * @throws Exception
     */
    Optional<ValidateCodeVO> create(ValidateCodeReq validateCodeReq, HttpServletResponse response) throws Exception;

    /**
     * 校验验证码
     *
     * @param validateCodeReq
     * @throws Exception
     */
    void validate(ValidateCodeReq validateCodeReq, HttpServletResponse response);

}
