package com.js.web.service;

import com.js.common.model.req.JsLoanApplyInfoReq;
import com.js.common.model.req.LoanApplicationReq;
import com.js.common.model.req.LoanCapitalReq;
import com.js.common.model.req.SignContractReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

import java.math.BigDecimal;

/**
 * @Description: 贷款信息申请接口
 * @Author: zhouyongsheng
 * @Create: 2019-06-13
 **/
public interface JsLoanApplicationService {

    /**
     * @Author zhouyongsheng
     * @Description 准入
     * @Date 2019/6/13
     **/
    ResponseMessage loanApply(JsLoanApplyInfoReq req);

    /**
     * 查询借款记录详细信息（放款详情需要）
     * @return
     */
    ResponseMessage  loanApplicationDetailed(String loanNo,String kycNaturalId);

    /**
     * 借款记录查询
     * @return
     */
    ResponseMessage queryLoan(LoanApplicationReq loanApplicationReq);

    /**
     * 借款记录详情
     * @return
     */
    ResponseMessage loanDetailed(String loanNo,String kycNaturalId);


    /**
     * 到签署支用合同查询
     * @return
     */
    ResponseMessage loanContract(String loanNo,String kycNaturalId);
    /**
     * 合同查询
     * @return
     */
    ResponseMessage queryContract(String loanNo,String kycNaturalId);

    /**
     * 签署合同
     * @param signContractReq
     * @return
     */
    ResponseMessage signContract(SignContractReq signContractReq,KycNaturalVO kycNaturalVO);

    /**
     * 签署合同
     * @param loanNo
     * @param kycNaturalVO
     * @return
     */
    ResponseMessage signVerification(String loanNo, KycNaturalVO kycNaturalVO);

    /**
     * 资金明细查询
     * @return
     */
    ResponseMessage capitalDetailed(LoanCapitalReq loanCapitalReq);

    /**
     * 资金明细详情
     * @return
     */
    ResponseMessage capitalDetailedDetails(String loanNo, String applyId);
}
