package com.js.web.controller.web;

import com.js.common.constant.Constant;
import com.js.common.model.req.ChPwdReq;
import com.js.common.model.req.ForgetPwdReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

/**
 * @ClassName: PasswordController
 * @Description: 密码controller
 * @Author: yjzhao
 * @Create: 2019-05-19  14:14
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class PasswordController {

    @Autowired
    private JsKycNaturalService jsKycNaturalService;
    /**
     * @Author yjzhao
     * @Description 密码加密获取公钥
     * @Date 2019/5/19 14:17
     * @Param [mobile, request, response]
     * @return ResponseMessage
     **/
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/password/getPwdKey")
    public ResponseMessage getPwdKey(@RequestParam(value = "phoneNo") String phoneNo,
                                     HttpServletRequest request, HttpServletResponse response) {
        return jsKycNaturalService.getPwdKey(phoneNo, request, response);
    }


    /**
     * @Author yjzhao
     * @Description 忘记密码-图形验证码
     * @Date 2019/5/19 14:17
     * @Param [mobile, request, response]
     * @return ResponseMessage
     **/
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/password/forgetPwd4Image")
    public ResponseMessage forgetPwd4Image (@RequestBody ForgetPwdReq forgetPwd,
                                      HttpServletRequest request, HttpServletResponse response) {
        return jsKycNaturalService.forgetPwd4Image(forgetPwd, request, response);
    }

    /**
     * @Author yjzhao
     * @Description 忘记密码-手机验证码
     * @Date 2019/5/19 14:17
     * @Param [mobile, request, response]
     * @return ResponseMessage
     **/
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/password/forgetPwd4SMS")
    public ResponseMessage forgetPwd4SMS (@RequestBody ForgetPwdReq forgetPwd,
                                      HttpServletRequest request, HttpServletResponse response) {
        return jsKycNaturalService.forgetPwd4SMS(forgetPwd, request, response);
    }

    /**
     * @Author yjzhao
     * @Description 修改密码
     * @Date 2019/5/19 14:17
     * @Param [mobile, request, response]
     * @return ResponseMessage
     **/
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/password/changePwd",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage changePwd (@Valid @RequestBody ChPwdReq chPwdReq,
                                  HttpServletRequest request, HttpServletResponse response) {
        return jsKycNaturalService.changePwd(chPwdReq, request, response);
    }

    /**
     * @Author liuh
     * @Description 忘记密码-修改密码最后操作
     * @Date 2019/7/19
     **/
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/password/changeNewPwd",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage changeNewPwd (@RequestBody ChPwdReq chPwdReq) {
        return jsKycNaturalService.changePwd(chPwdReq);
    }
}
