package com.js.web.controller.web;

import com.js.common.constant.Constant;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @ClassName: LogoutController
 * @Description: 登出
 * @Author: yjzhao
 * @Create: 2019-05-21  17:11
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE},
        consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class LogoutController {

    @Autowired
    private JsKycNaturalService jsKycNaturalService;
    
    /**
     * @Author yjzhao
     * @Description 登出
     * @Date 2019/5/21 17:12
     * @Param [request, response]
     * @return ResponseMessage
     **/
    @PostMapping(value =  Constant.ApiLoginAuth.AUTHC +"/logOut")
    public ResponseMessage logOut(HttpServletRequest request, HttpServletResponse response) {
        return jsKycNaturalService.logOut(request, response);
    }
}
