package com.js.web.controller.pay;

import com.js.api.jspay.service.ApiKycSunrateStoreService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.constant.Constant;
import com.js.common.model.vo.common.ResponseMessage;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.ws.rs.GET;

/**
 * @Author liuh
 * @Description 与寻汇查询前后端交互controller
 * @Date 2019/5/21
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsSunrateQueryController {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateRegisterService apiSunrateRegisterService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycSunrateStoreService apiKycSunrateStoreService;

    /**
     * 开户结果查询 接口
     * @Author liuh
     * @Date 2019/6/25
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/queryXhAccount")
    public ResponseMessage queryXhAccount(@RequestParam String browserIP,@RequestParam String orgCode){
        return apiSunrateRegisterService.queryXhAccount(browserIP,orgCode);
    }

    /**
     * 5.5查询店铺（合作方 -> 寻汇）
     * @Author liuh
     * @Date 2019/6/25
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/sunrateStoreList")
    public ResponseMessage sunrateStoreList(@RequestParam String browserIP,@RequestParam String orgCode){
        return apiKycSunrateStoreService.sunrateStoreList(orgCode,browserIP);
    }
}
