package com.js.web.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.poi.excel.ExcelReader;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.*;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsFileSerivce;
import com.js.web.service.JsPaySupplierService;
import com.js.web.utils.ExcelBizUtil;
import com.js.web.validate.code.ValidateCodeException;
import com.js.web.validate.code.ValidateCodeProcessorHolder;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.poi.ss.usermodel.Cell;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.CellType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Slf4j
@Service
public class JsPaySupplierServiceImpl implements JsPaySupplierService {

    @Autowired
    JsFileSerivce jsFileSerivce;
    @Autowired
    private ValidateCodeProcessorHolder validateCodeProcessorHolder;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPaySupplierBatService apiJsPaySupplierBatService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPaySupplierInfoService apiJsPaySupplierInfoService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPaySupplierPayeeService apiJsPaySupplierPayeeService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPaySupplierBatDtlService apiJsPaySupplierBatDtlService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPaySunrateBankService apiJsPaySunrateBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsTradeService apiJsTradeService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycStoreService apiKycStoreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsPaySysAcctService apiJsPaySysAcctService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsUserTreatyService apiJsUserTreatyService;

    @Value("${js.file.path}")
    private String filePath;


    @Override
    public ResponseMessage queryRcvList(String kycNaturalId) {
        return apiJsPaySupplierPayeeService.queryRcvList(kycNaturalId);
    }
    @Override
    public ResponseMessage queryTreaty(String kycNaturalId) {
        return apiJsUserTreatyService.queryTreaty(kycNaturalId,"1");
    }

    @Override
    public ResponseMessage submitTreaty(String kycNaturalId) {
        return apiJsUserTreatyService.submitTreaty(kycNaturalId,"1");
    }
    @Override
    public ResponseMessage storeList(KycShowStoreReq kycShowStoreReq) {
        return apiKycStoreService.queryStoreListByCurr(kycShowStoreReq);
    }

    // 供应商付款 余额列表
    @Override
    public ResponseMessage queryAvailableList(KycNaturalVO kycNaturalVO) {
        return apiJsPaySunrateBankService.findSunrateBankInfoList(kycNaturalVO);
    }

    @Override
    public ResponseMessage uploadFile(MultipartFile file, FileType fileType, FileResourceType fileResourceType, CertiFileType certiFileType, String currFlag) {
        if (file.isEmpty()) {
            return ResultUtil.error(ResultEnum.FILE_UPLOAD_ERROR);
        }
        String fileName = file.getOriginalFilename();
//        String filePath = "D:/temp/";
        File dest = new File(filePath + fileName);
        try {
            jsFileSerivce.uploadFile(file, fileType, fileResourceType, certiFileType);
            file.transferTo(dest);
            log.info("上传成功");
        } catch (IOException e) {
            log.error(e.toString(), e);
        }
        return fileParse(filePath + fileName, 0, currFlag);
    }

    private ResponseMessage fileParse(String path ,int index,String flag) {
        //模板处理 sheetIndex=0代表第一个
        log.info("上传文件：" + path + "开始解析。。。。。");
        ExcelReader readerModel = ExcelBizUtil.getFlag(path,index,flag);
        String resJson = "";
        ResponseMessage responseMessage = new ResponseMessage();
        ExcelBizUtil excelBizUtil = new ExcelBizUtil();
        if(readerModel != null){
            if(flag.equals(CurrEnum.CURR_CNY.getEnumCode())){
                List<JsPaySupplierCNYVO> list = excelBizUtil.readExcel(readerModel,new JsPaySupplierCNYVO());
                resJson = JSON.toJSONString(list);
            }else if(flag.equals(CurrEnum.CURR_USD.getEnumCode())){
                List<JsPaySupplierUSDVO> list = excelBizUtil.readExcel(readerModel,new JsPaySupplierUSDVO());
                resJson = JSON.toJSONString(list);
            }else if(flag.equals(CurrEnum.CURR_EUR.getEnumCode())){
                List<JsPaySupplierEURVO> list = excelBizUtil.readExcel(readerModel,new JsPaySupplierEURVO());
                resJson = JSON.toJSONString(list);
            }else if(flag.equals(CurrEnum.CURR_GBP.getEnumCode())){
                List<JsPaySupplierGBPVO> list = excelBizUtil.readExcel(readerModel,new JsPaySupplierGBPVO());
                resJson = JSON.toJSONString(list);
            }else if(flag.equals(CurrEnum.CURR_HKD.getEnumCode())){
                List<JsPaySupplierHKDVO> list = excelBizUtil.readExcel(readerModel,new JsPaySupplierHKDVO());
                resJson = JSON.toJSONString(list);
            }else{
                log.error("上传文件非原始基础模板文件!" );
                return ResultUtil.error(ResultEnum.UPDATE_FILE_FIAL_MODEL);
            }
        }else{
            log.error("上传文件与币种选择不符合!");
            return ResultUtil.error(ResultEnum.UPDATE_FILE_UNKNOWN);
        }

        responseMessage.setData(resJson);
        responseMessage.setSuccess(true);
        return responseMessage;
    }

    private String checkExcelData(List<JsPaySupplierVO> list){
        String regex1 = "([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})(((0[13578]|1[02])(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)(0[1-9]|[12][0-9]|30))|(02(0[1-9]|[1][0-9]|2[0-8])))([0-9]{1,12})";
        Pattern pattern = null;
        String regex2 = "([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})(((0[13578]|1[02])(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)(0[1-9]|[12][0-9]|30))|(02(0[1-9]|[1][0-9]|2[0-8])))";
        Set<String> set = new TreeSet<>();
        for(JsPaySupplierVO jsPaySupplierVO : list){
            StringBuilder reasons = new StringBuilder();
            pattern = Pattern.compile(regex1);
            String businessNo = jsPaySupplierVO.getBusinessNo();
            if(set.contains(businessNo)){
                reasons.append("商户流水号重复;");
            }else{
                set.add(businessNo);
            }
            Matcher m = pattern.matcher(businessNo);
            if(!m.matches()){
                reasons.append("商户流水号不符合规则;");
            }
            String bankAccType = jsPaySupplierVO.getBankAccType();
            if(!"对公".equals(bankAccType) && !"对私".equals(bankAccType)){
                reasons.append("收款方账户类型不符合规则;");
            }

            try {
                String cusName = jsPaySupplierVO.getCusName();
                byte[] bs = cusName.getBytes("UTF-8");
                if(bs.length >128){
                    reasons.append("收款方户名长度超长;");
                }
                String rcvBankName = jsPaySupplierVO.getRcvBankName();
                bs = rcvBankName.getBytes("UTF-8");
                if(bs.length >120){
                    reasons.append("收款银行名称长度超长;");
                }
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }

        }
        return "";
    }

    @Override
    public ResponseMessage paySupplierSubmit(JsPaySupplierBatReq jsPaySupplierBatReq , KycNaturalVO kycNaturalVO) {
        // 验证码校验
        ResponseMessage responseMessage =  checkValidate(jsPaySupplierBatReq);
        if(!responseMessage.isSuccess()){
            return responseMessage;
        }
        List<JsPaySupplierInfoReq> paySupplierInfoReqList = jsPaySupplierBatReq.getPaySupplierInfoReqList();
        RegisterType registerType = kycNaturalVO.getRegisterType();
        String kycNaturalId = kycNaturalVO.getId();
        String orgCode = apiSunrateTradePriceService.findOrgCode(kycNaturalId,registerType);
        log.info("供应商付款社会组织机构代码为："+ orgCode );
        String batchId = IdUtil.simpleUUID();
        jsPaySupplierBatReq.setId(batchId);
        jsPaySupplierBatReq.setBatchStatus(BatStatus.TRADE_UNKNOWN.queryEnumCode()); //  交易待处理
        jsPaySupplierBatReq.setOrgCode(orgCode);
        log.info("供应商付款批次入表，批次号：" + batchId + ".");
        responseMessage = apiJsPaySupplierBatService.addPaySupplierBat(jsPaySupplierBatReq);
        if(!responseMessage.isSuccess()){
            return responseMessage;
        }
        // 受益人当前审核状态
        Map<String,String> beneficiarySttMap = new HashMap<String,String>();
        // 总金额 和总笔数
        BigDecimal totalAmt = jsPaySupplierBatReq.getTotalAmt();
        int totalNum = Integer.valueOf(jsPaySupplierBatReq.getTotalNum());

        if(paySupplierInfoReqList.size() != totalNum){
            log.error("总笔数填写错误！");
        }
        // 勾选付款店铺列表
        List<JsPayVatSubAcctInfoVO> subAcctNoInfoList = jsPaySupplierBatReq.getSubAcctNoInfoList();
        String beneficiaryStatus = "";
        int index = 0;
        int seqNo =0;
        // 人民币账户处理
        if(CurrEnum.CURR_CNY.getEnumCode().equals(jsPaySupplierBatReq.getRcvCur())){
            // 先查出公司人民币账户受益人信息
            JsPaySysAcctVO jsPaySysAcctVO = apiJsPaySysAcctService.queryBeneficiaryRmbList();
            JsPaySupplierInfoReq jsPaySupplierInfoReq = new JsPaySupplierInfoReq();
            jsPaySupplierInfoReq.setKycNaturalId(kycNaturalId);
            jsPaySupplierInfoReq.setTradeCur(jsPaySupplierBatReq.getPayCur());
            jsPaySupplierInfoReq.setOrgCode(orgCode);
//            String beneficiaryId = apiJsPaySupplierInfoService.queryBeneficiary(jsPaySupplierInfoReq);
            jsPaySupplierInfoReq.setRcvBankName(jsPaySysAcctVO.getReceivingBankName());
            jsPaySupplierInfoReq.setRcvBankCard(jsPaySysAcctVO.getAcctNo());
            jsPaySupplierInfoReq.setCusName(jsPaySysAcctVO.getAcctName());
            jsPaySupplierInfoReq.setRcvBankCountry(jsPaySysAcctVO.getReceivingAcctCountry());
            jsPaySupplierInfoReq.setRouteType("3");
            jsPaySupplierInfoReq.setSwiftBic(jsPaySysAcctVO.getSwiftCode());

            responseMessage = handleBeneficiary(jsPaySupplierInfoReq,orgCode,jsPaySupplierBatReq.getPayCur(),jsPaySupplierBatReq.getBrowserIP(),kycNaturalVO,beneficiarySttMap);
            if(responseMessage.isSuccess()){
                beneficiaryStatus = responseMessage.getData().toString();
            }else{
                return responseMessage;
            }
            // 受益人状态查询
            for(JsPaySupplierInfoReq jsPaySupplierReq : paySupplierInfoReqList){
                jsPaySupplierReq.setBatchId(batchId);
                jsPaySupplierReq.setId(IdUtil.simpleUUID());
                addPaySupplierDtl(subAcctNoInfoList,index,seqNo, jsPaySupplierReq);
            }
            if(CommonConstant.XH_BENEFICIARY_PASS.equals(beneficiaryStatus)){  // 供应商审核通过

            }


            //
//            tradeMarketOrder(,kycNaturalId);

        }else{
            for(JsPaySupplierInfoReq jsPaySupplierInfoReq : paySupplierInfoReqList){
                jsPaySupplierInfoReq.setKycNaturalId(kycNaturalId);
                jsPaySupplierInfoReq.setTradeCur(jsPaySupplierBatReq.getPayCur());
                jsPaySupplierInfoReq.setOrgCode(orgCode);
                responseMessage = handleBeneficiary(jsPaySupplierInfoReq,orgCode,jsPaySupplierBatReq.getPayCur(),jsPaySupplierBatReq.getBrowserIP(),kycNaturalVO,beneficiarySttMap);
                if(responseMessage.isSuccess()){
                    beneficiaryStatus = responseMessage.getData().toString();
                }else{
                    return responseMessage;
                }
                 if(CommonConstant.XH_BENEFICIARY_PASS.equals(beneficiaryStatus)){  // 供应商审核通过
                    // 记录付款记录 + 调用寻汇市价锁汇交易接口
                    jsPaySupplierInfoReq.setBatchId(batchId);
                    jsPaySupplierInfoReq.setId(IdUtil.simpleUUID());

                    responseMessage = apiJsPaySupplierInfoService.addSupplierPayTrade(jsPaySupplierInfoReq,kycNaturalVO);
                    if(responseMessage.isSuccess()){
                        jsPaySupplierInfoReq.setStatus(StatusEnum.RATETRADEING.queryEnumCode());
                    }else{
                        jsPaySupplierInfoReq.setStatus(StatusEnum.RATETRADEFAIL.queryEnumCode());
                    }
                    addPaySupplierDtl(subAcctNoInfoList,index,seqNo, jsPaySupplierInfoReq);

//                    return apiJsPayVatPaymentInfoService.addVatPayTrade(jsPayVatPaymentInfoReq,kycNaturalVO);
                }else{
                     // 供应商付款明细记录
                     jsPaySupplierInfoReq.setBatchId(batchId);
                     jsPaySupplierInfoReq.setId(IdUtil.simpleUUID());
                     addPaySupplierDtl(subAcctNoInfoList,index,seqNo, jsPaySupplierInfoReq);
                 }

            }
        }
        return null;
    }

    private ResponseMessage checkValidate(JsPaySupplierBatReq jsPaySupplierBatReq) {
        log.info("供应商付款提交，第1步验证码校验" + jsPaySupplierBatReq.getPhone());
        try {
            KycBankReq kycBankReq = new KycBankReq();
            kycBankReq.setMarkStr(jsPaySupplierBatReq.getMarkStr());
            kycBankReq.setPhone(jsPaySupplierBatReq.getPhone());
            kycBankReq.setSmsCode(jsPaySupplierBatReq.getSmsCode());
            ValidateCodeReq validateCodeReq = regiserReqConvertToValidateCodeReq(kycBankReq);
            validateCodeProcessorHolder.findValidateCodeProcessor("sms").validate(validateCodeReq, null);
        } catch (ValidateCodeException exception) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(), exception.getMessage());
        } catch (Exception e) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(), ResultEnum.VALIDATE_CODE_ERROT.getMsg());
        }
        return ResultUtil.success();
    }
    /**
     * 受益人操作
     * @param jsPaySupplierInfoReq
     * @param orgCode
     * @param payCur
     * @param browserIP
     * @param kycNaturalVO
     * @param beneficiarySttMap
     * @return
     */
    private ResponseMessage handleBeneficiary(JsPaySupplierInfoReq jsPaySupplierInfoReq,String orgCode,String payCur,String browserIP,KycNaturalVO kycNaturalVO,
                                              Map<String,String> beneficiarySttMap){
        String beneficiaryId = apiJsPaySupplierInfoService.queryBeneficiary(jsPaySupplierInfoReq);
        String beneficiaryStatus = "";
        ResponseMessage responseMessage= null;
        // 验证 手工填写的机构信息是否已登记
        if(StringUtils.isNotBlank(beneficiaryId)){ // 已登记过，验证受益人是否通过
            beneficiaryStatus = beneficiarySttMap.get(beneficiaryId);
            if(StringUtils.isBlank(beneficiaryStatus)){
                beneficiaryStatus = apiJsPaySupplierInfoService.querySupplierInfoStatus(beneficiaryId);
                beneficiarySttMap.put(beneficiaryId,beneficiaryStatus);
            }
        }
        if(StringUtils.isBlank(beneficiaryId) || CommonConstant.XH_BENEFICIARY_NOT_PASS.equals(beneficiaryStatus) || StringUtils.isEmpty(beneficiaryStatus)){
            //添加受益人
            log.info("添加受益人 {}",beneficiaryId);
            responseMessage = addBeneficiary(jsPaySupplierInfoReq,orgCode,browserIP,payCur,kycNaturalVO);
            if(responseMessage.isSuccess()){
                JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
                beneficiaryId = jsonObject.getString("beneficiaryId");
                beneficiaryStatus = jsonObject.getString("beneficiaryStatus");
                jsPaySupplierInfoReq.setBeneficiaryId(beneficiaryId);
                jsPaySupplierInfoReq.setStatus(StatusEnum.AUDITING.queryEnumCode());
                beneficiarySttMap.put(beneficiaryId,beneficiaryStatus);
            }else{
                return responseMessage;
            }
            // 添加供应商
            responseMessage = insertPaySupplierInfo(jsPaySupplierInfoReq);
            if(!responseMessage.isSuccess()){
                return responseMessage;
            }
            // 添加用户供应商关系
            responseMessage = apiJsPaySupplierPayeeService.inserPaySupplierPayee(jsPaySupplierInfoReq);
            if(!responseMessage.isSuccess()){
                return responseMessage;
            }
        }else{
            return ResultUtil.success(beneficiaryStatus);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
    /**
     * 添加收款人
     * @param jsPaySupplierUserInfoReq
     * @param kycNaturalVO
     * @return
     */
    @Override
    public ResponseMessage addSupplierRcv(JsPaySupplierUserInfoReq jsPaySupplierUserInfoReq,KycNaturalVO kycNaturalVO) {
        JsPaySupplierInfoReq jsPaySupplierInfoReq = new JsPaySupplierInfoReq();
        jsPaySupplierInfoReq.setKycNaturalId(jsPaySupplierUserInfoReq.getKycNaturalId());
        jsPaySupplierInfoReq.setRcvBankCard(jsPaySupplierUserInfoReq.getRcvBankCard());
        jsPaySupplierInfoReq.setIban(jsPaySupplierUserInfoReq.getIban());
        jsPaySupplierInfoReq.setSwiftBic(jsPaySupplierUserInfoReq.getSwiftBic());
        jsPaySupplierInfoReq.setSortCode(jsPaySupplierUserInfoReq.getSortCode());
        jsPaySupplierInfoReq.setCusName(jsPaySupplierUserInfoReq.getCusName());
        jsPaySupplierInfoReq.setRcvBankName(jsPaySupplierUserInfoReq.getRcvBankName());
        jsPaySupplierInfoReq.setRcvBankCountry(jsPaySupplierUserInfoReq.getRcvBankCountry());
        jsPaySupplierInfoReq.setRouteType(jsPaySupplierUserInfoReq.getRouteType());
        RegisterType registerType = kycNaturalVO.getRegisterType();
        String kycNaturalId = jsPaySupplierUserInfoReq.getKycNaturalId();
        String orgCode = apiSunrateTradePriceService.findOrgCode(kycNaturalId,registerType);
        Map<String,String> beneficiarySttMap = new HashMap<>();
        ResponseMessage responseMessage = handleBeneficiary(jsPaySupplierInfoReq,orgCode,jsPaySupplierUserInfoReq.getPayCur(),jsPaySupplierUserInfoReq.getBrowserIP(),kycNaturalVO,beneficiarySttMap);
        if(!responseMessage.isSuccess()){
            ResultUtil.error(ResultEnum.UNKNOW_ERROR.getCode(), ResultEnum.UNKNOW_ERROR.getMsg());
        }else{
            if(CommonConstant.XH_BENEFICIARY_PASS.equals(responseMessage.getData().toString())){
                return  ResultUtil.error(ResultEnum.RCV_USER_ALREADY.getCode(), ResultEnum.RCV_USER_ALREADY.getMsg() + ", 请确认之后再添加!");
            }
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private void addPaySupplierDtl(List<JsPayVatSubAcctInfoVO> subAcctNoInfoList, int index ,int seqNo ,JsPaySupplierInfoReq jsPaySupplierInfoReq){
        BigDecimal tradeAmt = jsPaySupplierInfoReq.getTradeAmt();
        for(;index<subAcctNoInfoList.size();index ++){
            JsPayVatSubAcctInfoVO jsPayVatSubAcctInfoVO = subAcctNoInfoList.get(index);
            BigDecimal subAcctAmt = jsPayVatSubAcctInfoVO.getPayAmt();
            if(subAcctAmt.compareTo(tradeAmt)>0){ // 店铺余额够支付
                jsPaySupplierInfoReq.setStoreId(jsPayVatSubAcctInfoVO.getStoreId());
                jsPaySupplierInfoReq.setStoreName(jsPayVatSubAcctInfoVO.getStoreName());
                jsPaySupplierInfoReq.setSubAcctNo(jsPayVatSubAcctInfoVO.getSubAcctNo());
                jsPaySupplierInfoReq.setStorePlateform(jsPayVatSubAcctInfoVO.getStorePlateform());
                jsPayVatSubAcctInfoVO.setPayAmt(subAcctAmt.subtract(tradeAmt));
                jsPaySupplierInfoReq.setSeqNo(seqNo+"");
                insertPaySupplierDtl(jsPaySupplierInfoReq);
                // 添加到交易总表中
                insertJsTrade(jsPaySupplierInfoReq);
                seqNo++;
                break;
            }else{
                jsPaySupplierInfoReq.setTradeAmt(subAcctAmt);
                jsPaySupplierInfoReq.setStoreId(jsPayVatSubAcctInfoVO.getStoreId());
                jsPaySupplierInfoReq.setStoreName(jsPayVatSubAcctInfoVO.getStoreName());
                jsPaySupplierInfoReq.setSubAcctNo(jsPayVatSubAcctInfoVO.getSubAcctNo());
                jsPaySupplierInfoReq.setStorePlateform(jsPayVatSubAcctInfoVO.getStorePlateform());
                jsPaySupplierInfoReq.setSeqNo(seqNo+"");
                insertPaySupplierDtl(jsPaySupplierInfoReq);
                // 添加到交易总表中
                insertJsTrade(jsPaySupplierInfoReq);
                seqNo++;
                jsPaySupplierInfoReq.setTradeAmt(tradeAmt.subtract(subAcctAmt));
            }
        }
    }

    private void insertJsTrade(JsPaySupplierInfoReq jsPaySupplierInfoReq){
        JsTradeVO jsTradeVO = new JsTradeVO();
        jsTradeVO.setAccType("");
        jsTradeVO.setCurId("");
        jsTradeVO.setInAcct("");
        jsTradeVO.setInAcctName("");
        jsTradeVO.setKycNaturalId("");
        jsTradeVO.setOutAcct("");
        jsTradeVO.setOutAcctName("");
        jsTradeVO.setOutAmt(jsPaySupplierInfoReq.getPayAmt());
        jsTradeVO.setProcessStatus("");
        jsTradeVO.setTradeAmt(jsPaySupplierInfoReq.getTradeAmt());
        jsTradeVO.setTradeNo("");
        jsTradeVO.setTradeSubType("");
        jsTradeVO.setTradeType("");
        jsTradeVO.setTradeDts(new Date());

        apiJsTradeService.addTradeRecord(jsTradeVO);

    }

    private void tradeMarketOrder(JsPaySupplierInfoReq jsPaySupplierInfoReq){
        JsPaySunrateTradeMarketOrderReq JsPaySunrateTradeMarketOrderReq = new JsPaySunrateTradeMarketOrderReq();

        String kycNaturalId = jsPaySupplierInfoReq.getKycNaturalId();
        String kycSunrateStoreId = jsPaySupplierInfoReq.getStoreId();
        String kycSunrateBankId = "";
        apiJsPaySunrateTradeLockPriceService.tradeMarketOrder(JsPaySunrateTradeMarketOrderReq,kycNaturalId,kycSunrateStoreId,kycSunrateBankId);
    }

    private void insertPaySupplierDtl(JsPaySupplierInfoReq jsPaySupplierInfoReq){
        apiJsPaySupplierBatDtlService.insertPaySupplierDtl(jsPaySupplierInfoReq);
    }

    private ResponseMessage addBeneficiary(JsPaySupplierInfoReq jsPaySupplierInfoReq,String orgCode,String browserIP,String payCur, KycNaturalVO kycNaturalVO){
        log.info("添加受益人，组织接口参数数据 start:");
        KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq = new KycSunrateBeneficiaryReq();
        kycSunrateBeneficiaryReq.setOrgCode(orgCode);
        kycSunrateBeneficiaryReq.setBankName(jsPaySupplierInfoReq.getRcvBankName());
//        String taxStationType = jsPayVatPaymentInfoReq.getTaxStationType().getEnumCode();
        kycSunrateBeneficiaryReq.setBeneficiaryAcctNo(CurrEnum.CURR_GBP.getEnumCode().equals(payCur)?jsPaySupplierInfoReq.getIban():jsPaySupplierInfoReq.getRcvBankCard());
        kycSunrateBeneficiaryReq.setBeneficiaryAddr("受益人地址");
        kycSunrateBeneficiaryReq.setBeneficiaryType(BeneficiaryTypeEnum.PAY_SUPPLIER);
        kycSunrateBeneficiaryReq.setBeneficiaryName(jsPaySupplierInfoReq.getCusName());
        kycSunrateBeneficiaryReq.setBrowserIP(browserIP);
        kycSunrateBeneficiaryReq.setCountryCode(jsPaySupplierInfoReq.getRcvBankCountry());
        kycSunrateBeneficiaryReq.setCur(payCur);
        kycSunrateBeneficiaryReq.setIban(jsPaySupplierInfoReq.getIban());
        kycSunrateBeneficiaryReq.setRouteType(jsPaySupplierInfoReq.getRouteType());
        kycSunrateBeneficiaryReq.setSwiftcode(jsPaySupplierInfoReq.getSortCode());
        kycSunrateBeneficiaryReq.setRemark("供应商付款");
        log.info("添加受益人，调用寻汇接口start:");
        ResponseMessage responseMessage = apiSunrateBeneficiaryService.beneficiaryCreate(kycSunrateBeneficiaryReq,kycNaturalVO);
        return responseMessage;
    }

    private ValidateCodeReq regiserReqConvertToValidateCodeReq(KycBankReq kycBankReq){
        ValidateCodeReq validateCodeReq = new ValidateCodeReq();
        validateCodeReq.setMarkStr(kycBankReq.getMarkStr());
        validateCodeReq.setPhoneNo(kycBankReq.getPhone());
        validateCodeReq.setSmsCode(kycBankReq.getSmsCode());
        return validateCodeReq;
    }
    // 添加供应商信息
    private ResponseMessage insertPaySupplierInfo(JsPaySupplierInfoReq jsPaySupplierInfoReq) {
        jsPaySupplierInfoReq.setId(IdUtil.simpleUUID());
        return apiJsPaySupplierInfoService.insertPaySupplierInfo(jsPaySupplierInfoReq);
    }

    public static void main(String[] args) {
        String regex1 = "([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})(((0[13578]|1[02])(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)(0[1-9]|[12][0-9]|30))|(02(0[1-9]|[1][0-9]|2[0-8])))(\\d{1,12})$";
        String regex2 = "\\d{1,12}";
        Pattern pattern = Pattern.compile(regex1);
        Matcher m = pattern.matcher("20150201000210200021");
        if(!m.matches()){
            System.out.println(false);
        }else{
            System.out.println(true);
        }
    }
}
