package com.js.web.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jsloan.service.ApiJsLoanRepaymentService;
import com.js.api.jspay.service.*;
import com.js.api.jspay.service.chinapnr.ChinaPNRAccountExchangeService;
import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.api.jspay.service.chinapnr.ChinaPNRPaySubstituteService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.constant.SunrateConstant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.RedisUtil;
import com.js.common.util.ReqNoUtil;
import com.js.common.util.ResultUtil;
import com.js.web.service.*;
import com.js.web.utils.ValidatorUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Description: 寻汇虚拟银行账户服务实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class JsKycSunrateServiceImpl implements JsKycSunrateService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPaySunrateBankTradeInService apiJsPaySunrateBankTradeInService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateRegisterService apiSunrateRegisterService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPaySunrateBankService apiJsPaySunrateBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycSunrateStoreService apiKycSunrateStoreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsLoanApplyInfoService apiJsLoanApplyInfoService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycBankService apiKycBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ChinaPNRPayOpenAccountService chinaPNRPayOpenAccountService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ChinaPNRPaySubstituteService chinaPNRPaySubstituteService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPaySysAcctService apiJsPaySysAcctService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPayTradeService apiJsPayTradeService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPayUserAcctService apiJsPayUserAcctService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    ChinaPNRAccountExchangeService chinaPNRAccountExchangeService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    ApiKycNaturalService apiKycNaturalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsLoanRepaymentService apiJsLoanRepaymentService;
    @Autowired
    SunrateTradePriceService sunrateTradePriceService;
    @Autowired
    WaiHuiService waiHuiService;
    @Autowired
    IMailService iMailService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private JsPayVatPaymentInfoService jsPayVatPaymentInfoService;

    @Override
    public ResponseMessage virtualNotice(JsPaySunrateBankReq jsPaySunrateBankReq){
        log.info("寻汇虚拟子账户通知开始:{}", JSON.toJSONString(jsPaySunrateBankReq));
        ValidatorUtil.paramsValid(jsPaySunrateBankReq);
        ResponseMessage responseMessage = apiJsPaySunrateBankService.virtualNotice(jsPaySunrateBankReq);
        log.info("寻汇虚拟子账户通知结束");
        return responseMessage;
    }

    @Override
    public ResponseMessage registerCreateNotice(KycSunrateRegisterNoticeReq kycSunrateRegisterNoticeReq) {
        log.info("寻汇开户结果通知开始:{}", JSON.toJSONString(kycSunrateRegisterNoticeReq));
        ValidatorUtil.paramsValid(kycSunrateRegisterNoticeReq);
        ResponseMessage responseMessage = apiSunrateRegisterService.registerCreateNotice(kycSunrateRegisterNoticeReq);
        log.info("寻汇开户结果通知结束 : {}",responseMessage.isSuccess());
        if(responseMessage.isSuccess()){
            Thread thread = new Thread(() -> {
                StringBuffer sb = new StringBuffer("<p style=\"margin: 0;line-height: 24px;font-size: 14px;\">恭喜您通过了及时雨Pay账户的实名认证审核！详情请[<a href='https://www.jishiyupay.com/'>登录及时雨Pay</a>]查看查看。</p >");
                boolean sendResult = iMailService.sendTemplateHtmlMail(kycSunrateRegisterNoticeReq.getRegisterEmail(),"实名认证审核结果提醒",sb.toString(),kycSunrateRegisterNoticeReq.getRegisterMobile());
                log.info("发送邮件结果：{}",sendResult);
                iMailService.sendRemindEmail("实名认证审核结果提醒", "用户：" + kycSunrateRegisterNoticeReq.getRegisterMobile() + "实名认证审核结果 : " + (1 == kycSunrateRegisterNoticeReq.getRegisterStatus() ? "通过" : "未通过"), EmailRemindTypeEnum.REMIND_EMAIL);
            });
            thread.start();
        }
        return responseMessage;
    }

    @Override
    public ResponseMessage bankTradeInNotice(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq) {
        log.info("寻汇入账通知处理-开始:{}", JSON.toJSONString(jsPaySunrateBankTradeInReq));
        ValidatorUtil.paramsValid(jsPaySunrateBankTradeInReq);

        JsPaySunrateBankTradeInVO bankTradeInVO = apiJsPaySunrateBankTradeInService.findBankTradeIn(jsPaySunrateBankTradeInReq);
        if(null != bankTradeInVO){
            log.info("入账通知已推送过，不予再次处理");
            return ResultUtil.error(ResultEnum.SEND_ALREADY);
        }
        JsPaySunrateBankReq jsPaySunrateBankReq = new JsPaySunrateBankReq();
        jsPaySunrateBankReq.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        jsPaySunrateBankReq.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        jsPaySunrateBankReq.setBankCardNo(jsPaySunrateBankTradeInReq.getBankCardNo());
        JsPaySunrateBankVO jsPaySunrateBankVO = apiJsPaySunrateBankService.findSunrateBankInfo(jsPaySunrateBankReq, null);
        if(null == jsPaySunrateBankVO){
            log.error("未查询到虚拟账号信息：orgCode:{}，subAcctNo:{}",jsPaySunrateBankTradeInReq.getOrgCode(),jsPaySunrateBankTradeInReq.getSubAcctNo());
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        log.info("寻汇入账通知处理-开始");
        Date tradeInDate = new Date();
        jsPaySunrateBankTradeInReq.setCreateDts(tradeInDate);
        ResponseMessage responseMessage = apiJsPaySunrateBankTradeInService.bankTradeInNotice(jsPaySunrateBankTradeInReq,jsPaySunrateBankVO);
        log.info("寻汇入账通知处理-结束,返回结果:{}",responseMessage);
        if(!responseMessage.isSuccess()){
            return responseMessage;
        }
        boolean isMatches = (boolean)responseMessage.getData();
        if(isMatches){
            log.info("更新账户余额开始");
            ResponseMessage updateVirtualAmtResponse = apiJsPaySunrateBankService.updateVirtualAmt(jsPaySunrateBankTradeInReq,jsPaySunrateBankVO);
            log.info("更新账户余额结束,返回结果:{}",updateVirtualAmtResponse);
//            if(updateVirtualAmtResponse.isSuccess() && jsPaySunrateBankTradeInReq.getTransinAmt().compareTo(CommonConstant.SURATE_TRADE_MIN_AMT) > -1){
//                Thread thread = new Thread(() -> {
//                   exeRefund(jsPaySunrateBankTradeInReq,jsPaySunrateBankVO);
//                });
//                thread.start();
//            }
        }
        Thread thread = new Thread(() -> {
            sendEmail(jsPaySunrateBankVO.getKycNaturalId(),tradeInDate,jsPaySunrateBankVO.getCurId(),isMatches,jsPaySunrateBankTradeInReq.getTransinAmt());
        });
        thread.start();
//        if(jsPaySunrateBankTradeInReq.getTransinAmt().compareTo(CommonConstant.SURATE_TRADE_MIN_AMT) > -1) {
//            Thread thread1 = new Thread(() -> {
//                exeRefund(jsPaySunrateBankTradeInReq, jsPaySunrateBankVO);
//            });
//            thread1.start();
//        }
        return responseMessage;
    }

    private void sendEmail(String kycNaturalId,Date tradeInDate,String currency,boolean isMatches,BigDecimal amt){
        try{
            if(StringUtils.isBlank(kycNaturalId)){
                return;
            }
            KycNaturalVO kycNaturalVO = apiKycNaturalService.getKycNaturaById(kycNaturalId);
            if(null == kycNaturalVO){
                return;
            }
            if(isMatches) {
                StringBuffer sb = new StringBuffer("<p style=\"margin: 0;line-height: 24px;font-size: 14px;\">您的账户于" + DateUtil.format(tradeInDate, "yyyy年MM月dd日HH:mm") + "成功入账{" + currency + "}" + amt + "，您可登录您的及时雨Pay账户办理提现，详情请[<a href='https://www.jishiyupay.com/'>登录及时雨Pay</a>]查看查看。</p >");
                boolean sendResult = iMailService.sendTemplateHtmlMail(kycNaturalVO.getEmail(), "账户入账提醒", sb.toString(), kycNaturalVO.getPhoneNo());
                log.info("发送邮件结果：{}", sendResult);
                iMailService.sendRemindEmail("用户入账通知", "用户：" + kycNaturalVO.getPhoneNo() + "于" + DateUtil.format(tradeInDate, "yyyy年MM月dd日HH:mm") + "成功入账{" + currency + "}" + amt, EmailRemindTypeEnum.REMIND_EMAIL);
            }else{
                StringBuffer sb = new StringBuffer("<p style=\"margin: 0;line-height: 24px;font-size: 14px;\">您的账户于" + DateUtil.format(tradeInDate, "yyyy年MM月dd日HH:mm") + "有一笔资金{" + currency + "}" + amt + "未入账成功，原因可能是：</p >")
                        .append("<p style=\"margin: 0;line-height: 24px;font-size: 14px;\">1.您的实名认证和店铺交易信息未通过审核；</p >")
                        .append("<p style=\"margin: 0;line-height: 24px;font-size: 14px;\">2.您的收款来源未通过审核。</p >")
                        .append("<p style=\"margin: 0 0 40px;line-height: 24px;font-size: 14px;\">请尽快[<a href='https://www.jishiyupay.com/'>登录及时雨Pay</a>]处理，若在15天内未处理，系统将自动退款。</p >");
                boolean sendResult = iMailService.sendTemplateHtmlMail(kycNaturalVO.getEmail(), "账户入账挂起提醒", sb.toString(), kycNaturalVO.getPhoneNo());
                log.info("发送邮件结果：{}", sendResult);
                iMailService.sendRemindEmail("账户入账挂起提醒", "用户：" + kycNaturalVO.getPhoneNo() + "于" + DateUtil.format(tradeInDate, "yyyy年MM月dd日HH:mm") + "有一笔资金{" + currency + "}" + amt + "未入账成功", EmailRemindTypeEnum.REMIND_EMAIL);
            }
        }catch (Exception ex){
            log.error("发送邮件异常:",ex);
        }
    }

    private void exeRefund(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq,JsPaySunrateBankVO jsPaySunrateBankVO){
        String kycNaturalId = jsPaySunrateBankVO.getKycNaturalId();
        ResponseMessage responseMessage = apiJsLoanRepaymentService.queryVerificationLoan(kycNaturalId);
        log.info("查询贷款记录返回结果:{}",responseMessage);
        if(!responseMessage.isSuccess()){
            log.info("用户{}未查询到需要还款的记录信息",kycNaturalId);
            return;
        }
        JSONObject shouldRefundInfo = (JSONObject)responseMessage.getData();
        Date startDate = shouldRefundInfo.getDate("startDate");
        if(startDate.compareTo(new Date()) > 0){
            log.info("当前日期小于应还最早起始日期:{}",startDate);
            return;
        }



        WaiHuiVO waiHuiInfo = waiHuiService.getWaiHuiInfo(jsPaySunrateBankVO.getCurId());


        BigDecimal scaleTransinAmt = jsPaySunrateBankTradeInReq.getTransinAmt().multiply(new BigDecimal(0.35)).setScale(2,BigDecimal.ROUND_HALF_UP);
        BigDecimal txnAmt = scaleTransinAmt.compareTo(CommonConstant.SURATE_TRADE_MIN_AMT) < 0 ? CommonConstant.SURATE_TRADE_MIN_AMT : scaleTransinAmt;
    }

    @Override
    public ResponseMessage storeAuditNotice(SunrateStoreAuditReq sunrateStoreAuditReq) {
        ValidatorUtil.paramsValid(sunrateStoreAuditReq);
        log.info("寻汇店铺审核通知操作开始:{}", JSON.toJSONString(sunrateStoreAuditReq));
        ResponseMessage responseMessage = apiKycSunrateStoreService.storeAuditNotice(sunrateStoreAuditReq);
        log.info("寻汇店铺审核通知操作结束：{}",responseMessage.isSuccess());
        if(responseMessage.isSuccess()){
            String kycNaturalId = (String)responseMessage.getData();
            Thread thread = new Thread(() -> {
                sendStoreAuditEmail(kycNaturalId,sunrateStoreAuditReq);
            });
            thread.start();
        }
        return responseMessage;
    }

    private void sendStoreAuditEmail(String kycNaturalId,SunrateStoreAuditReq sunrateStoreAuditReq){
        try{
            if(StringUtils.isBlank(kycNaturalId)){
                return;
            }
            KycNaturalVO kycNaturalVO = apiKycNaturalService.getKycNaturaById(kycNaturalId);
            if(null == kycNaturalVO){
                return;
            }
            if("1".equals(sunrateStoreAuditReq.getStatus())) {
                StringBuffer sb = new StringBuffer("<p style=\"margin: 0;line-height: 24px;font-size: 14px;\">恭喜您通过了店铺信息的认证审核，您的店铺可以收款了！详情请[<a href='https://www.jishiyupay.com/'>登录及时雨Pay</a>]查看查看。</p >");
                boolean sendResult = iMailService.sendTemplateHtmlMail(kycNaturalVO.getEmail(), "店铺审核结果", sb.toString(), kycNaturalVO.getPhoneNo());
                log.info("发送邮件结果：{}", sendResult);
                iMailService.sendRemindEmail("用户店铺审核结果", "用户：" + kycNaturalVO.getPhoneNo() + "，店铺:" + sunrateStoreAuditReq.getStoreName() + "审核已通过", EmailRemindTypeEnum.REMIND_EMAIL);
            }else{
                StringBuffer sb = new StringBuffer("<p style=\"margin: 0;line-height: 24px;font-size: 14px;\">很抱歉，您店铺信息的认证未通过审核，原因如下：</p >")
                        .append("<p style=\"margin: 0;line-height: 24px;font-size: 14px;\">" + sunrateStoreAuditReq.getRemark() +"</p >")
                        .append("<p style=\"margin: 0 0 40px;line-height: 24px;font-size: 14px;\">请[<a href='https://www.jishiyupay.com/'>登录及时雨Pay</a>]重新提交资料。</p >");
                boolean sendResult = iMailService.sendTemplateHtmlMail(kycNaturalVO.getEmail(), "店铺审核结果", sb.toString(), kycNaturalVO.getPhoneNo());
                log.info("发送邮件结果：{}", sendResult);
                iMailService.sendRemindEmail("用户店铺审核结果", "用户：" + kycNaturalVO.getPhoneNo() + "，店铺:" + sunrateStoreAuditReq.getStoreName() + "审核未通过,原因：" + sunrateStoreAuditReq.getRemark(), EmailRemindTypeEnum.REMIND_EMAIL);
            }
        }catch (Exception ex){
            log.error("发送邮件异常:",ex);
        }
    }


    @Override
    public ResponseMessage beneficiayAuditNotice(SunrateBeneficiaryAuditReq sunrateBeneficiaryAuditReq) {
        log.info("寻汇受益人审核通知操作开始:{}", JSON.toJSONString(sunrateBeneficiaryAuditReq));
        ValidatorUtil.paramsValid(sunrateBeneficiaryAuditReq);
        ResponseMessage responseMessage = apiSunrateBeneficiaryService.beneficiayAuditNotice(sunrateBeneficiaryAuditReq);
        if(responseMessage.isSuccess()){
            Object object = responseMessage.getData();
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(object));
            String beneficiaryId = jsonObject.getString("beneficiaryId");
            String beneficiaryType = jsonObject.getString("beneficiaryType");
            String beneficiaryStatus = jsonObject.getString("beneficiaryStatus");
            if(BeneficiaryTypeEnum.VAT_PAYMENT.equals(beneficiaryType)){
                jsPayVatPaymentInfoService.beneficiayAuditNotice(beneficiaryId,beneficiaryStatus);
            }
        }
        log.info("寻汇受益人审核通知操作结束：{}",responseMessage.isSuccess());
        return responseMessage;
    }

    @Override
    public ResponseMessage bankTradeOutNotice(JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq) {
        log.info("寻汇出账通知处理-开始:{}",JSON.toJSONString(jsPaySunrateBankTradeOutReq));
        ValidatorUtil.paramsValid(jsPaySunrateBankTradeOutReq);
        JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO = apiJsPaySunrateTradeLockPriceService.findTradeLockInfo(jsPaySunrateBankTradeOutReq);
        if(null == jsPaySunrateTradeLockPriceVO || StringUtils.isBlank(jsPaySunrateTradeLockPriceVO.getId())){
            log.error("未查询到锁汇交易信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        log.info("查询到提交锁汇交易信息:{}",JSON.toJSONString(jsPaySunrateTradeLockPriceVO));
        if(SunrateConstant.TRADE_OUT_COMPLETE.equals(jsPaySunrateTradeLockPriceVO.getTxnStatus())){
            log.error("出账通知已执行过:{}",jsPaySunrateBankTradeOutReq);
            return ResultUtil.error(ResultEnum.SEND_ALREADY);
        }
        if(jsPaySunrateBankTradeOutReq.getPayAmt().compareTo(jsPaySunrateTradeLockPriceVO.getBuyAmt()) != 0){
            log.error("出账金额与锁汇金额不相符,出账金额：{}，锁汇买入金额：{}",jsPaySunrateBankTradeOutReq.getPayAmt(),jsPaySunrateTradeLockPriceVO.getBuyAmt());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),ResultEnum.ERROR.getMsg() + "出账金额与锁汇金额不相符");
        }
        jsPaySunrateTradeLockPriceVO.setTxnStatus(SunrateConstant.TRADE_OUT_COMPLETE);
        jsPaySunrateTradeLockPriceVO.setProcessStatus(ProcessStatusEnum.TRADE_UNPROCESSED);
        int updateCount = apiJsPaySunrateTradeLockPriceService.updateLockPrice(jsPaySunrateTradeLockPriceVO);
        log.info("更新锁汇表状态信息，成功条数：{}",updateCount);
        //锁汇交易类型
        TradeTypeEnum tradeType = jsPaySunrateTradeLockPriceVO.getTradeType();
        //当锁汇交易为提现操作时
        if(TradeTypeEnum.TRADE_WITHDRAW.equals(tradeType)){
            log.info("出账通知-锁汇请求为提现请求");
            ResponseMessage bankCardResponse = apiKycBankService.getBankCard(jsPaySunrateTradeLockPriceVO.getKycBankId());
            if(!bankCardResponse.isSuccess()){
                log.error("未查询到提现银行卡信息：{}",jsPaySunrateTradeLockPriceVO.getKycBankId());
                jsPaySunrateTradeLockPriceVO.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED_FAILURE);
                apiJsPaySunrateTradeLockPriceService.updateLockPrice(jsPaySunrateTradeLockPriceVO);
                iMailService.sendRemindEmail("寻汇出账通知处理异常","未查询到提现银行卡信息kycBankId:" + jsPaySunrateTradeLockPriceVO.getKycBankId(),EmailRemindTypeEnum.WARN_EMAIL);
                return ResultUtil.error(ResultEnum.SUCCESS);
            }
            KycBankVO kycBankVO = (KycBankVO)bankCardResponse.getData();
            exeServiceAccountProcess(jsPaySunrateTradeLockPriceVO);
            //银行卡提现渠道
            SysPlateformType routeType = kycBankVO.getRouteType();
            if(SysPlateformType.HFGJ.equals(routeType)){
                //走汇付国际提现通道
                return ResultUtil.success(ResultEnum.SUCCESS);
            }else if(SysPlateformType.SUNRATE.equals(routeType)){
                //走寻汇提现通道-处理提现外币后续操作
                apiJsPayTradeService.withdrawBySunrateRouteType(jsPaySunrateTradeLockPriceVO);
            }else{
                log.error("提现渠道不正确：{}",routeType);
                jsPaySunrateTradeLockPriceVO.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED_FAILURE);
                apiJsPaySunrateTradeLockPriceService.updateLockPrice(jsPaySunrateTradeLockPriceVO);
                return ResultUtil.error(ResultEnum.SUCCESS);
            }
        }else{
            log.error("交易类型不正确：{}",tradeType);
            jsPaySunrateTradeLockPriceVO.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED_FAILURE);
            apiJsPaySunrateTradeLockPriceService.updateLockPrice(jsPaySunrateTradeLockPriceVO);
            return ResultUtil.error(ResultEnum.SUCCESS);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private void exeServiceAccountProcess(JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO){
        try {
            List<JsPaySysAcctVO> jsPaySysAcctList = apiJsPaySysAcctService.findJsPaySysAcctVOList();
            if (CollectionUtils.isEmpty(jsPaySysAcctList)) {
                log.error("预置平台账户信息查询不存在，请确认");
                iMailService.sendRemindEmail("寻汇出账-记账异常", "预置平台账户信息查询不存在，请确认" + JSON.toJSONString(jsPaySysAcctList) + ",lockNo:" + jsPaySunrateTradeLockPriceVO.getLockNo(), EmailRemindTypeEnum.WARN_EMAIL);
                return;
            }
            log.info("查询到预制平台账户信息:{}条", jsPaySysAcctList.size());
            JsPaySysAcctVO jsPaySysAcctVOYFJSServiceFee = null;
            JsPaySysAcctVO jsPaySysAcctVOYFJS = null;
            for (JsPaySysAcctVO jsPaySysAcctVO : jsPaySysAcctList) {
                if (JsPaySysAcctTypeEnum.YFJS_SERVICE_FEE.equals(jsPaySysAcctVO.getAcctType()) && jsPaySysAcctVO.getCur().equals(jsPaySunrateTradeLockPriceVO.getSellCur())) {
                    jsPaySysAcctVOYFJSServiceFee = jsPaySysAcctVO;
                }else if(JsPaySysAcctTypeEnum.HFGJ_YFJS_BENEFICIARY.equals(jsPaySysAcctVO.getAcctType()) && jsPaySysAcctVO.getCur().equals(jsPaySunrateTradeLockPriceVO.getBuyCur())){
                    jsPaySysAcctVOYFJS = jsPaySysAcctVO;
                }
            }
            if (null == jsPaySysAcctVOYFJSServiceFee || null == jsPaySysAcctVOYFJS) {
                log.error("预置平台账户信息查询不存在，请确认");
                iMailService.sendRemindEmail("寻汇出账-记账异常", "预置平台账户信息查询不存在，请确认" + JSON.toJSONString(jsPaySysAcctList) + ",lockNo:" + jsPaySunrateTradeLockPriceVO.getLockNo(), EmailRemindTypeEnum.WARN_EMAIL);
                return;
            }
            String kycNaturalId = jsPaySunrateTradeLockPriceVO.getKycNaturalId();
            String kycSunrateStoreId = jsPaySunrateTradeLockPriceVO.getKycSunrateStoreId();
            KycSunrateStoreVO sunrateStoreInfo = apiKycSunrateStoreService.findSunrateStoreInfo("", kycSunrateStoreId, kycNaturalId);
            if (null == sunrateStoreInfo) {
                log.error("查询寻汇店铺信息不存在：{}", kycSunrateStoreId);
                iMailService.sendRemindEmail("寻汇出账-记账异常", "查询寻汇店铺信息不存在kycSunrateStoreId:" + kycSunrateStoreId + ",lockNo:" + jsPaySunrateTradeLockPriceVO.getLockNo(), EmailRemindTypeEnum.WARN_EMAIL);
                return;
            }
            //服务费费
            BigDecimal serviceChargeAmt = jsPaySunrateTradeLockPriceVO.getChargeAmt();
            log.info("{}服务费记账账户记入服务费金额:{}", jsPaySysAcctVOYFJSServiceFee.getId(), serviceChargeAmt);
            String batchNo = ReqNoUtil.getReqNo();
            BigDecimal zeroInit = new BigDecimal(0);
            //服务费账户记账流水
            if (null != serviceChargeAmt && serviceChargeAmt.compareTo(new BigDecimal(0)) > 0) {
                jsPaySysAcctVOYFJSServiceFee.setAvailableAmt(jsPaySysAcctVOYFJSServiceFee.getAvailableAmt().add(serviceChargeAmt));
                JsPayTradeReq jsPayTradeReq = convertToJsPayTradeReq(jsPaySunrateTradeLockPriceVO, jsPaySysAcctVOYFJSServiceFee.getAcctNo(),jsPaySysAcctVOYFJSServiceFee.getAcctName(),serviceChargeAmt,
                        "", "", zeroInit,serviceChargeAmt, batchNo,jsPaySysAcctVOYFJSServiceFee.getAvailableAmt(),jsPaySysAcctVOYFJSServiceFee.getFrozenAmt());
                jsPayTradeReq.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
                jsPayTradeReq.setTradeType(TradeTypeEnum.TRADE_IN);
                jsPayTradeReq.setCurId(jsPaySunrateTradeLockPriceVO.getSellCur());
                jsPayTradeReq.setTradeSubType(TradeSubTypeEnum.WITHDRAW_FEE);
                ResponseMessage responseMessage = apiJsPaySysAcctService.opeartorAcct(jsPayTradeReq, jsPaySysAcctVOYFJSServiceFee);
                log.info("更新保存{}账户记账完成：{}",jsPaySysAcctVOYFJSServiceFee.getAcctNo(),responseMessage);
            }
            BigDecimal buyAmt = jsPaySunrateTradeLockPriceVO.getBuyAmt();
            if(CommonConstant.TRADE_CURRENCY_CNH.equals(jsPaySunrateTradeLockPriceVO.getBuyCur())) {
                log.info("{}大受益人账户记入入账金额:{}", jsPaySysAcctVOYFJS.getId(),buyAmt);
                jsPaySysAcctVOYFJS.setAvailableAmt(jsPaySysAcctVOYFJS.getAvailableAmt().add(buyAmt));
                JsPayTradeReq jsPayTradeReq = convertToJsPayTradeReq(jsPaySunrateTradeLockPriceVO, jsPaySysAcctVOYFJS.getAcctNo(), jsPaySysAcctVOYFJS.getAcctName(),buyAmt,
                        "", "",zeroInit,buyAmt, batchNo,jsPaySysAcctVOYFJS.getAvailableAmt(),jsPaySysAcctVOYFJS.getFrozenAmt());
                jsPayTradeReq.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
                jsPayTradeReq.setTradeType(TradeTypeEnum.TRADE_IN);
                jsPayTradeReq.setTradeSubType(TradeSubTypeEnum.TRADE_IN);
                ResponseMessage responseMessage = apiJsPaySysAcctService.opeartorAcct(jsPayTradeReq, jsPaySysAcctVOYFJS);
                log.info("更新保存{}账户记账完成：{}",jsPaySysAcctVOYFJS.getAcctNo(),responseMessage);
            }
        }catch (Exception ex){
            log.error("插入账户流水异常：", ex);
            iMailService.sendRemindEmail("寻汇出账-记账异常", "服务异常lockNo:" + jsPaySunrateTradeLockPriceVO.getLockNo(), EmailRemindTypeEnum.WARN_EMAIL);
        }
    }

    @Override
    public synchronized void exeQueryAccountDispose(){
        ResponseMessage responseMessage = chinaPNRAccountExchangeService.queryAccount();
        if(!responseMessage.isSuccess()){
            log.error("查询主账户余额失败：{}",responseMessage);
            iMailService.sendRemindEmail("汇付结汇回调-处理出账代发异常","查询主账户余额失败:" + responseMessage,EmailRemindTypeEnum.WARN_EMAIL);
            return;
        }
        log.info("查询余额结果：{}",responseMessage);
        Map<String,String> resMap = (Map<String,String>)responseMessage.getData();
        String balance = resMap.get("balance");
        if(StringUtils.isBlank(balance)){
            log.info("主账户余额查询成功，但余额字段返回空");
            iMailService.sendRemindEmail("汇付结汇回调-处理出账代发异常","主账户余额查询成功，但余额字段返回空:" + responseMessage,EmailRemindTypeEnum.WARN_EMAIL);
            return;
        }
        //单位分
        BigDecimal bigAcctBalance = BigDecimal.valueOf(Long.parseLong(balance));
        if(bigAcctBalance.compareTo(new BigDecimal(0)) < 1){
            return;
        }
        //单位元
        BigDecimal bigAcctBalaceYuan = bigAcctBalance.divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_UP);
        List<JsPaySunrateTradeLockPriceVO> lockPriceList = apiJsPaySunrateTradeLockPriceService.getLockPriceList();
        if(CollectionUtils.isEmpty(lockPriceList)){
            log.info("查询结果为空，不再执行");
            return;
        }
        for(int i = 0 ;i < lockPriceList.size(); i++){
            JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO = lockPriceList.get(i);
            if(bigAcctBalaceYuan.compareTo(jsPaySunrateTradeLockPriceVO.getBuyAmt()) >= 0){
                log.info("主账户余额：{}，需要操作金额：{}",bigAcctBalaceYuan,jsPaySunrateTradeLockPriceVO.getBuyAmt());
                bigAcctBalaceYuan = bigAcctBalaceYuan.subtract(jsPaySunrateTradeLockPriceVO.getBuyAmt());
                log.info("主账户操作完成后剩余金额：{}",bigAcctBalaceYuan);
                //锁汇交易类型
                TradeTypeEnum tradeType = jsPaySunrateTradeLockPriceVO.getTradeType();
                //当锁汇交易为提现操作时
                if(TradeTypeEnum.TRADE_WITHDRAW.equals(tradeType)){
                    log.info("结汇回调处理-锁汇请求为提现请求");
                    ResponseMessage bankCardResponse = apiKycBankService.getBankCard(jsPaySunrateTradeLockPriceVO.getKycBankId());
                    if(!bankCardResponse.isSuccess()){
                        log.error("未查询到提现银行卡信息：{}",jsPaySunrateTradeLockPriceVO.getKycBankId());
                        iMailService.sendRemindEmail("汇付结汇回调-处理出账代发异常","未查询到提现银行卡信息kycBankId:" + jsPaySunrateTradeLockPriceVO.getKycBankId() + ",lockNo:" + jsPaySunrateTradeLockPriceVO.getLockNo(),EmailRemindTypeEnum.WARN_EMAIL);
                        return;
                    }
                    KycBankVO kycBankVO = (KycBankVO)bankCardResponse.getData();
                    //银行卡提现渠道
                    SysPlateformType routeType = kycBankVO.getRouteType();
                    if(SysPlateformType.HFGJ.equals(routeType)){
                        //走汇付国际提现通道
                        withdrawByHFGJRouteType(kycBankVO,jsPaySunrateTradeLockPriceVO);
                    }else{
                        log.error("提现渠道：{},交易已处理",routeType);
                    }
                }else{
                    log.error("交易类型不正确：{}",tradeType);
                }
            }else{
                log.info("主账户余额不足停止执行，主余额：{}，交易金额：{}",bigAcctBalaceYuan,jsPaySunrateTradeLockPriceVO.getBuyAmt());
                break;
            }
        }
    }

    private ResponseMessage withdrawByHFGJRouteType(KycBankVO kycBankVO,JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO){
        List<JsPaySysAcctVO> jsPaySysAcctList = apiJsPaySysAcctService.findJsPaySysAcctVOList();
        if(CollectionUtils.isEmpty(jsPaySysAcctList)){
            log.error("预置平台账户信息查询不存在，请确认");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        log.info("查询到预制平台账户信息:{}条" ,jsPaySysAcctList.size());
        JsPaySysAcctVO jsPaySysAcctVOYFJS = null;
        JsPaySysAcctVO jsPaySysAcctVOYFJSRATE = null;
        for(JsPaySysAcctVO jsPaySysAcctVO : jsPaySysAcctList){
            if(JsPaySysAcctTypeEnum.HFGJ_YFJS_BENEFICIARY.equals(jsPaySysAcctVO.getAcctType()) && jsPaySysAcctVO.getCur().equals(jsPaySunrateTradeLockPriceVO.getBuyCur())){
                jsPaySysAcctVOYFJS = jsPaySysAcctVO;
            }else if(JsPaySysAcctTypeEnum.HFGJ_YFJS_RATE.equals(jsPaySysAcctVO.getAcctType())){
                jsPaySysAcctVOYFJSRATE = jsPaySysAcctVO;
            }
        }
        if(null == jsPaySysAcctVOYFJS || null == jsPaySysAcctVOYFJSRATE){
            log.error("预置平台账户信息查询不存在，请确认");
            iMailService.sendRemindEmail("汇付结汇回调-处理出账代发异常","预置平台账户信息查询不存在，请确认" + JSON.toJSONString(jsPaySysAcctList) + ",lockNo:" + jsPaySunrateTradeLockPriceVO.getLockNo(),EmailRemindTypeEnum.WARN_EMAIL);
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        String kycNaturalId = kycBankVO.getKycNaturalId();
        String kycSunrateStoreId = jsPaySunrateTradeLockPriceVO.getKycSunrateStoreId();
        KycSunrateStoreVO sunrateStoreInfo = apiKycSunrateStoreService.findSunrateStoreInfo("", kycSunrateStoreId, kycNaturalId);
        if(null == sunrateStoreInfo){
            log.error("查询寻汇店铺信息不存在：{}",kycSunrateStoreId);
            iMailService.sendRemindEmail("汇付结汇回调-处理出账代发异常","查询寻汇店铺信息不存在kycSunrateStoreId:" + kycSunrateStoreId + ",lockNo:" + jsPaySunrateTradeLockPriceVO.getLockNo(),EmailRemindTypeEnum.WARN_EMAIL);
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        //卖出外币金额
        BigDecimal sellAmt = jsPaySunrateTradeLockPriceVO.getSellAmt();
        //汇差金额
        BigDecimal rateAmt = jsPaySunrateTradeLockPriceVO.getRateAmt();
        //用户可到账金额
        BigDecimal userAmt = jsPaySunrateTradeLockPriceVO.getBuyAmt().subtract(rateAmt).setScale(2,BigDecimal.ROUND_HALF_UP);
        log.info("卖出外币金额:{},买入金额：{},汇差人民币金额：{},用户可到账金额：{}",sellAmt,jsPaySunrateTradeLockPriceVO.getBuyAmt(),rateAmt,userAmt);
        List<JsPayTradeReq> jsPayTradeReqList = new ArrayList<>();
        String batchNo = ReqNoUtil.getReqNo();//请求汇付生成统一批次号

        List<ChinaPNRSubstituteDetails> chinaPNRSubstituteDetailsList = new ArrayList<>();
        BigDecimal zeroInit = new BigDecimal(0);
        if(null != rateAmt && rateAmt.compareTo(new BigDecimal(0)) > 0) {
            jsPaySysAcctVOYFJSRATE.setAvailableAmt(jsPaySysAcctVOYFJSRATE.getAvailableAmt().add(rateAmt));
            JsPayTradeReq jsPayTradeReqYFJSRATE = convertToJsPayTradeReq(jsPaySunrateTradeLockPriceVO, jsPaySysAcctVOYFJSRATE.getAcctNo(), jsPaySysAcctVOYFJSRATE.getAcctName(),rateAmt,
                    "", "",zeroInit, rateAmt, batchNo,jsPaySysAcctVOYFJSRATE.getAvailableAmt(),jsPaySysAcctVOYFJSRATE.getFrozenAmt());
            jsPayTradeReqYFJSRATE.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSEDING);
            jsPayTradeReqYFJSRATE.setTradeType(TradeTypeEnum.TRADE_IN);
            jsPayTradeReqYFJSRATE.setTradeSubType(TradeSubTypeEnum.RATE);
            jsPayTradeReqList.add(jsPayTradeReqYFJSRATE);
            chinaPNRSubstituteDetailsList.add(convertToChinaPNRSubstituteDetails("030",rateAmt,jsPaySysAcctVOYFJSRATE.getAcctNo(),jsPaySysAcctVOYFJSRATE.getAcctName(),jsPayTradeReqYFJSRATE.getSubstituteDetailId(),"H","",jsPaySysAcctVOYFJSRATE.getIdNo(),"00"));//汇差代发

            jsPaySysAcctVOYFJS.setAvailableAmt(jsPaySysAcctVOYFJS.getAvailableAmt().subtract(rateAmt));
            JsPayTradeReq jsPayTradeReqYFJS = convertToJsPayTradeReq(jsPaySunrateTradeLockPriceVO,"","",zeroInit,
                    jsPaySysAcctVOYFJS.getAcctNo(),jsPaySysAcctVOYFJS.getAcctName(),rateAmt,rateAmt,batchNo,jsPaySysAcctVOYFJS.getAvailableAmt(),jsPaySysAcctVOYFJS.getFrozenAmt());
            jsPayTradeReqYFJS.setTradeType(TradeTypeEnum.TRADE_WITHDRAW);
            jsPayTradeReqYFJS.setTradeSubType(TradeSubTypeEnum.WITHDRAW);
            jsPayTradeReqYFJS.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
            jsPayTradeReqList.add(jsPayTradeReqYFJS);
        }
        JsPayTradeReq jsPayTradeReqUser = convertToJsPayTradeReq(jsPaySunrateTradeLockPriceVO,kycBankVO.getAccountNo(),kycBankVO.getAccountName(),userAmt,
                "","",zeroInit,userAmt,batchNo,userAmt,zeroInit);
        jsPayTradeReqUser.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSEDING);
        jsPayTradeReqUser.setTradeType(TradeTypeEnum.TRADE_IN);
        jsPayTradeReqUser.setTradeSubType(TradeSubTypeEnum.WITHDRAW);
        jsPayTradeReqList.add(jsPayTradeReqUser);

        jsPaySysAcctVOYFJS.setAvailableAmt(jsPaySysAcctVOYFJS.getAvailableAmt().subtract(userAmt));
        JsPayTradeReq jsPayTradeReqYFJS = convertToJsPayTradeReq(jsPaySunrateTradeLockPriceVO,"","",zeroInit,
                jsPaySysAcctVOYFJS.getAcctNo(),jsPaySysAcctVOYFJS.getAcctName(),userAmt,userAmt,batchNo,jsPaySysAcctVOYFJS.getAvailableAmt(),jsPaySysAcctVOYFJS.getFrozenAmt());
        jsPayTradeReqYFJS.setTradeType(TradeTypeEnum.TRADE_WITHDRAW);
        jsPayTradeReqYFJS.setTradeSubType(TradeSubTypeEnum.WITHDRAW);
        jsPayTradeReqYFJS.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
        jsPayTradeReqList.add(jsPayTradeReqYFJS);

        chinaPNRSubstituteDetailsList.add(convertToChinaPNRSubstituteDetails("020",userAmt,kycBankVO.getAccountNo(),kycBankVO.getAccountName(),jsPayTradeReqUser.getSubstituteDetailId(),BankAcctTypeEnum.COMPANY_SELF.equals(kycBankVO.getCompanyAcctType()) ? "P" : "C",kycBankVO.getBankCode(),kycBankVO.getIdNo(),BankAcctTypeEnum.COMPANY_SELF.equals(kycBankVO.getCompanyAcctType()) ? "00" : "62"));//客户虚拟账户提现代发
        ChinaPNRSubstituteReq chinaPNRSubstituteReq = convertToChinaPNRSubstituteReq(kycNaturalId,chinaPNRSubstituteDetailsList,jsPaySunrateTradeLockPriceVO,batchNo);
        ResponseMessage oldSubstituteTradeResponse = chinaPNRPaySubstituteService.oldSubstituteTrade(chinaPNRSubstituteReq);

        log.info("发起汇付旧接口代发结果：{}",JSON.toJSONString(oldSubstituteTradeResponse));
        if(!oldSubstituteTradeResponse.isSuccess()){
            log.error("发送汇付旧接口代发申请失败{}",oldSubstituteTradeResponse.getMsg());
            jsPaySunrateTradeLockPriceVO.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED_FAILURE);
            apiJsPaySunrateTradeLockPriceService.updateLockPrice(jsPaySunrateTradeLockPriceVO);
            iMailService.sendRemindEmail("汇付结汇回调-处理出账代发异常","发送汇付旧接口代发申请失败:" + oldSubstituteTradeResponse.getMsg() + ",lockNo:" + jsPaySunrateTradeLockPriceVO.getLockNo(),EmailRemindTypeEnum.WARN_EMAIL);
            return ResultUtil.success(ResultEnum.SUCCESS);
        }
        Map<String,Object> paramsMap = new HashMap<>();
        paramsMap.put("jsPaySysAcctVOYFJSRATE",jsPaySysAcctVOYFJSRATE);
        paramsMap.put("rateAmt",rateAmt);
        paramsMap.put("userAmt",userAmt);
        ResponseMessage withdrawTradeAddResponse = apiJsPayTradeService.jsPayWithdrawTradeAdd(paramsMap,jsPayTradeReqList);
        log.info("提现出账更新余额及增加账户流水信息结果：{}",withdrawTradeAddResponse);
        jsPaySunrateTradeLockPriceVO.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSEDING);
        apiJsPaySunrateTradeLockPriceService.updateLockPrice(jsPaySunrateTradeLockPriceVO);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private JsPayTradeReq convertToJsPayTradeReq(JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO,String inAcct,String inAcctName,BigDecimal inAmt,String outAcct,String outAcctName,BigDecimal outAmt
            ,BigDecimal tradeAmt,String tradeNo,BigDecimal userAcctAvailableAmt,BigDecimal userAcctFrozenAmt){
        JsPayTradeReq jsPayTradeReq = new JsPayTradeReq();
        jsPayTradeReq.setKycNaturalId(jsPaySunrateTradeLockPriceVO.getKycNaturalId());
        jsPayTradeReq.setKycSunrateStoreId(jsPaySunrateTradeLockPriceVO.getKycSunrateStoreId());
        jsPayTradeReq.setKycSunrateBankId(jsPaySunrateTradeLockPriceVO.getKycSunrateBankId());
        jsPayTradeReq.setInAcct(inAcct);
        jsPayTradeReq.setInAcctName(inAcctName);
        jsPayTradeReq.setOutAcct(outAcct);
        jsPayTradeReq.setOutAcctName(outAcctName);
        jsPayTradeReq.setTradeNo(tradeNo);
        jsPayTradeReq.setTxnNo(jsPaySunrateTradeLockPriceVO.getTxnNo());
        jsPayTradeReq.setLockNo(jsPaySunrateTradeLockPriceVO.getLockNo());
        jsPayTradeReq.setSubstituteDetailId(IdUtil.simpleUUID());
        jsPayTradeReq.setCurId(jsPaySunrateTradeLockPriceVO.getBuyCur());
        jsPayTradeReq.setOutAmt(outAmt);
        jsPayTradeReq.setInAmt(inAmt);
        jsPayTradeReq.setTradeAmt(tradeAmt);
        jsPayTradeReq.setUserAcctCurrAmt(userAcctAvailableAmt.add(userAcctFrozenAmt));
        jsPayTradeReq.setUserAcctAvailableAmt(userAcctAvailableAmt);
        jsPayTradeReq.setUserAcctFrozenAmt(userAcctFrozenAmt);
        jsPayTradeReq.setTradeDts(new Date());
        return jsPayTradeReq;
    }

    private ChinaPNRSubstituteReq convertToChinaPNRSubstituteReq(String kycNaturalId,List<ChinaPNRSubstituteDetails> chinaPNRSubstituteDetailsList,JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO,String batchNo){
        ChinaPNRSubstituteReq chinaPNRSubstituteReq = new ChinaPNRSubstituteReq();
        chinaPNRSubstituteReq.setKycNaturalId(kycNaturalId);
        chinaPNRSubstituteReq.setBatchNo(batchNo);//批次号
        chinaPNRSubstituteReq.setRequestId(IdUtil.simpleUUID());//请求流水号
        chinaPNRSubstituteReq.setPayTCnt(chinaPNRSubstituteDetailsList.size());//总笔数
        chinaPNRSubstituteReq.setPayTAmt(jsPaySunrateTradeLockPriceVO.getBuyAmt().multiply(new BigDecimal(100)).setScale(0));//总金额-转换为分-汇付要求
        chinaPNRSubstituteReq.setPayCur(CommonConstant.TRADE_CURRENCY_CNY);//交易币种
        chinaPNRSubstituteReq.setDetailsList(chinaPNRSubstituteDetailsList);
        return chinaPNRSubstituteReq;
    }

    private ChinaPNRSubstituteDetails convertToChinaPNRSubstituteDetails(String tradeType,BigDecimal detailAmt,String acctNo,String acctName,String substituteDetailId,String receivablesAccType,String bankCode,String idNo,String idType){
        ChinaPNRSubstituteDetails chinaPNRSubstituteDetails = new ChinaPNRSubstituteDetails();
        chinaPNRSubstituteDetails.setSubstituteDetailId(substituteDetailId);//代发明细流水号
        chinaPNRSubstituteDetails.setSubstituteDetailAmt(detailAmt.multiply(new BigDecimal(100)).setScale(0));//金额-转化为分-汇付要求
        if(StringUtils.isNotBlank(bankCode)){
            //获取汇付银行代码
            log.info("银行代码需要转换，转换前代码：{}",bankCode);
            String bankCodeRedis = redisUtil.get(Constant.REDIS_JS_PAY_BANCK + bankCode +"_010");
            bankCode = StringUtils.isBlank(bankCodeRedis) ? bankCode : bankCodeRedis;
            log.info("银行代码需要转换，转换后代码：{}",bankCode);
        }
        chinaPNRSubstituteDetails.setReceivablesBankCode(bankCode);//收款银行代码
        chinaPNRSubstituteDetails.setAccountNumbe(acctNo);//账号
        chinaPNRSubstituteDetails.setAccountName(acctName);//户名
        chinaPNRSubstituteDetails.setSubstituteType(tradeType);//交易类型-010 贷款服务本金 020 提现服务 030 汇差 040贷款服务费 050 提现服务费 060贷款服务利息
        chinaPNRSubstituteDetails.setDocumentType(idType);//证件类型 00–身份证
        chinaPNRSubstituteDetails.setIdentificationNumber(idNo);//证件号码
        chinaPNRSubstituteDetails.setProvince("上海");
        chinaPNRSubstituteDetails.setRegion("上海市");
        chinaPNRSubstituteDetails.setBranchName("上海市支行");
        chinaPNRSubstituteDetails.setPurpose("用途"); // 用途
        chinaPNRSubstituteDetails.setPaymentOutName("");//出款用户号
        chinaPNRSubstituteDetails.setPaymentBank("");//收款联行号
        chinaPNRSubstituteDetails.setReceivablesAccType(receivablesAccType);
        return chinaPNRSubstituteDetails;
    }
}
