package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycHolderCompanyService;
import com.js.api.jspay.service.ApiKycHolderPersonalService;
import com.js.common.constant.Constant;
import com.js.common.model.req.KycHolderCompanyReq;
import com.js.common.model.req.KycHolderPersonalReq;
import com.js.common.model.vo.KycHolderVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycHolderService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 申请虚拟账户-添加店铺服务实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class JsKycHolderServiceImpl implements JsKycHolderService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiKycHolderPersonalService apiKycHolderPersonalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiKycHolderCompanyService apiKycHolderCompanyService;

    @Override
    public ResponseMessage kycHolderList(String holderName, KycNaturalVO kycNaturalVO) {
        log.info("持有人：{}",holderName);
        List<KycHolderVO> kycHolderVOList = new ArrayList<>();
        List<KycHolderVO> optionalKycHolderVOListPersonal = apiKycHolderPersonalService.holderPersonalList(holderName,kycNaturalVO);
        if(CollectionUtils.isNotEmpty(optionalKycHolderVOListPersonal)){
            kycHolderVOList.addAll(optionalKycHolderVOListPersonal);
        }
        List<KycHolderVO> optionalKycHolderVOListCompany = apiKycHolderCompanyService.holderCompanyList(holderName,kycNaturalVO);
        if(CollectionUtils.isNotEmpty(optionalKycHolderVOListCompany)){
            kycHolderVOList.addAll(optionalKycHolderVOListCompany);
        }
        return ResultUtil.success(kycHolderVOList);
    }

    @Override
    public ResponseMessage holderPersonalAdd(KycHolderPersonalReq kycHolderPersonalReq, KycNaturalVO kycNaturalVO) {
        log.info("天剑持有人-个人入参：{}", JSON.toJSONString(kycHolderPersonalReq));
        return apiKycHolderPersonalService.holderPersonalAdd(kycHolderPersonalReq,kycNaturalVO);
    }

    @Override
    public ResponseMessage holderCompanyAdd(KycHolderCompanyReq kycHolderCompanyReq, KycNaturalVO kycNaturalVO) {
        log.info("添加持有人-企业入参：{}", JSON.toJSONString(kycHolderCompanyReq));
        return apiKycHolderCompanyService.holderCompanyAdd(kycHolderCompanyReq,kycNaturalVO);
    }
}
