package com.js.web.service.impl;

import com.js.api.jspay.service.chinapnr.ChinaPNRAccountExchangeService;
import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.api.jspay.service.chinapnr.ChinaPNRPaySubstituteService;
import com.js.api.jspay.service.chinapnr.ChinaPNRTransactionDetailsService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.ChinapnrCallbackSerivce;
import com.js.web.service.JsKycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;

import java.util.Map;

/**
 * @Description: 汇付国际回调
 * @Author: zhouyongsheng
 * @Create: 2019-06-18
 **/
@Slf4j
@Service
public class ChinapnrCallbackSerivceImpl implements ChinapnrCallbackSerivce {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ChinaPNRPaySubstituteService chinaPNRPaySubstituteService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ChinaPNRPayOpenAccountService chinaPNRPayOpenAccountService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    ChinaPNRTransactionDetailsService chinaPNRTransactionDetailsService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    ChinaPNRAccountExchangeService chinaPNRAccountExchangeService;
    @Autowired
    private JsKycSunrateService jsKycSunrateService;

    /**
     * 汇付国际提现回调
     * @param map
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage substituteNewCallback(Map<String, String> map) {
        ResponseMessage responseMessage = chinaPNRPaySubstituteService.newCallbackSubstitute(map);
        return responseMessage;
    }

    /**
     * 汇付国际还款汇差等回调
     * @param wholeStr
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage substituteOldCallback(String wholeStr) {
        ResponseMessage responseMessage = chinaPNRPaySubstituteService.oldCallbackSubstitute(wholeStr);
        return responseMessage;
    }

    /**
     * 汇付国际个人开户回调
     * @param map
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage opendAccountPersonal(Map<String, String> map) {
        ResponseMessage responseMessage = chinaPNRPayOpenAccountService.personalCallbackOpenAccount(map);
        return responseMessage;
    }

    /**
     * 汇付国际企业开户回调
     * @param map
     * @return
     * @throws Exception
     */
    @Override
    public ResponseMessage opendAccountEnterprise(Map<String, String> map) {
        ResponseMessage responseMessage = chinaPNRPayOpenAccountService.enterpriseCallbackOpenAccount(map);
        return responseMessage;
    }

    @Override
    public ResponseMessage transactionDetailsCallback(String responseStr) {
        return chinaPNRTransactionDetailsService.transactionDetailsCallback(responseStr);
    }

    @Override
    public ResponseMessage exchangeCallback(String wholeStr) {
        ResponseMessage responseMessage = ResultUtil.success(ResultEnum.SUCCESS);//chinaPNRAccountExchangeService.exchangeCallback(wholeStr);
//        if(responseMessage.getCode() == ResultEnum.CHINA_PNR_EXCHANGE_SUCCESS.getCode()){
            Thread t = new Thread(() -> {
                //执行方法
                jsKycSunrateService.exeQueryAccountDispose();
            });
            t.start();
//        }
        return responseMessage;
    }
}
