package com.js.web.service;
import com.js.common.model.req.RepaymentLoanReq;
import com.js.common.model.req.RepaymentOperationReq;
import com.js.common.model.req.RepaymentTrialReq;
import com.js.common.model.vo.common.ResponseMessage;


/**
 * @Author zhouyngsheng
 * @Description 还款信息接口
 * @Date 2019/8/1
 **/
public interface JsLoanRepaymentService {


    /**
     * 还款明细查询
     * @return
     */
    ResponseMessage detailed(String loanNo);

    /**
     * 需还款记录查询
     * @return
     */
    ResponseMessage loanSituation(RepaymentLoanReq repaymentLoanReq);

    /**
     * 还款操作
     * @return
     */
    ResponseMessage operation(RepaymentOperationReq repaymentOperationReq);

    /**
     * 还款试算
     * @param repaymentTrialReq
     * @return
     */
    ResponseMessage trial(RepaymentTrialReq repaymentTrialReq);

    /**
     * 店铺账户查询
     * @param kycNaturalId
     * @return
     */
    ResponseMessage queryStoreAccount(String kycNaturalId);

}
