package com.js.web.service;

import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

/**
 * @Description: 持有人（大陆个人，香港个人，大陆企业，香港企业）操作服务接口
 * @Author: liuh
 * @Create: 2019-05-23
 **/
public interface JsKycHolderService {
    /**
     * @Author liuh
     * @Description 持有人列表
     * @Date 2019/5/23
     **/
    ResponseMessage kycHolderList(String holderName, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 添加持有人-个人
     * @Date 2019/5/24
     **/
    ResponseMessage holderPersonalAdd(KycHolderPersonalReq kycHolderPersonalReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 实名认证-大陆企业-保存
     * @Date 2019/5/24
     **/
    ResponseMessage holderCompanyAdd(KycHolderCompanyReq kycHolderCompanyReq, KycNaturalVO kycNaturalVO);
}
