package com.js.web.controller.web;

import cn.hutool.core.lang.Validator;
import com.js.common.annotation.Phone;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.RegiserKycNaturalReq;
import com.js.common.model.req.ValidateCodeReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.Email;

/**
 * @Author yjzhao
 * @Description 注册Controller
 * @Date 2019/5/18 20:36
 * @Param 
 * @return 
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class RegisterController {

    @Autowired
    private JsKycNaturalService jsKycNaturalService;

    /**
     * 验证邮箱是否已经存在
     * @param email  邮箱
     * @param request 请求对象
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/register/verifyEmailExists")
    public ResponseMessage verifyEmailExists(@RequestParam(value = "email") String email, HttpServletRequest request) {
        if (!Validator.isEmail(email)) {
            return ResultUtil.error(ResultEnum.EMAIL_REGEX_ERROR);
        }
        return jsKycNaturalService.verifyEmailExists(email);
    }

    /**
     * 验证手机号码是否已经注册
     * @param phoneNo  手机号
     * @param request 请求对象
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/register/verifyMobileExists")
    public ResponseMessage verifyMobileExists(@RequestParam(value = "phoneNo") String phoneNo, HttpServletRequest request) {
        if (!Validator.isMobile(phoneNo)) {
            return ResultUtil.error(ResultEnum.PHONE_REGEX_ERROR);
        }
        return  jsKycNaturalService.verifyMobileExists(phoneNo);
    }

    /**
     * 注册提交
     * @param  regiserKycNaturalReq 注册用户表单对象
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/register/submit",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage register(@Valid @RequestBody RegiserKycNaturalReq regiserKycNaturalReq,
                   HttpServletRequest request, HttpServletResponse response) {

        return jsKycNaturalService.register(regiserKycNaturalReq, request, response);
    }

    /**
     * @Author yjzhao
     * @Description 邮箱绑定校验
     * @Date 2019/5/24 20:43
     * @Param [validateCodeReq, request, response]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/register/emailValidate",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage emailValidate(@Valid @RequestBody  ValidateCodeReq validateCodeReq,
                                    HttpServletRequest request, HttpServletResponse response) {

        return jsKycNaturalService.emailValidate(validateCodeReq, request, response);
    }
}
