package com.js.web.controller.loan;
import cn.hutool.core.io.IoUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsLoanBillFilePageReq;
import com.js.common.model.req.JsLoanBillFileReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsLoanBillFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

/**
 * @Author zhouyngsheng
 * @Description 贷款对账文件controller
 * @Date 2019/8/1
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class LoanBillFileController {

    @Autowired
    JsLoanBillFileService jsLoanBillFileService;

    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 对账文件申请查询
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loanBill/applyQuery",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage applyQuery(@Valid @RequestBody JsLoanBillFilePageReq jsLoanBillFilePageReq , HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        jsLoanBillFilePageReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsLoanBillFileService.applyQuery(jsLoanBillFilePageReq);
    }

    /**
     * 对账文件申请
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loanBill/applyOperation",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage applyOperation(@Valid @RequestBody JsLoanBillFileReq jsLoanBillFileReq , HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        jsLoanBillFileReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsLoanBillFileService.applyOperation(jsLoanBillFileReq);
    }

    /**
     * 对账文件下载
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/loanBill/download")
    public ResponseMessage download(@RequestParam(value = "loanBillNo",required = false) String loanBillNo,  HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        ResponseMessage message =  jsLoanBillFileService.download(optionalKycNaturalVO.get().getId(),loanBillNo);
        //excel文件名
        String fileName = "贷款对账单"+System.currentTimeMillis()+".xls";
        if(message.isSuccess()){
            ArrayList<Map<String, Object>> rows = (ArrayList<Map<String, Object>>)message.getData();
            // 通过工具类创建writer，默认创建xls格式
            ExcelWriter writer = ExcelUtil.getWriter();
            // 一次性写出内容，使用默认样式，强制输出标题
            writer.write(rows, true);
           //out为OutputStream，需要写出到的目标流
            try {
                String userAgent = request.getHeader("User-Agent");
                // 针对IE或者以IE为内核的浏览器：
                if (userAgent.contains("MSIE") || userAgent.contains("Trident")) {
                    fileName = java.net.URLEncoder.encode(fileName, "UTF-8");
                } else {
                    // 非IE浏览器的处理：
                    fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
                }
                response.setContentType("application/vnd.ms-excel;charset=utf-8");
                response.addHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", fileName));
                OutputStream out = response.getOutputStream();
                writer.flush(out, true);
               // 关闭writer，释放内存
                writer.close();
               //此处记得关闭输出Servlet流
                IoUtil.close(out);
            } catch (Exception ex) {
                ex.printStackTrace();
                return ResultUtil.error(ResultEnum.ERROR.getCode(),"文件下载失败");
            }

        }
        return message;
    }

}
