package com.js.web.controller.loan;


import com.js.common.constant.Constant;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.EnterpriseInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * 向借贷系统提供企业相关信息
 *
 * @author liutianyu
 */
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class EnterpriseInfoController {

    @Autowired
    EnterpriseInfoService enterpriseInfoService;

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/enterpriseInfo/getEnterpriseInfo/{kycNaturalId}")
    public ResponseMessage getFullDetailsByName(@PathVariable("kycNaturalId") String kycNaturalId){
        return enterpriseInfoService.getEnterpriseInfo(kycNaturalId);
    }
}
