package com.js.web.validate.code;

import com.js.web.properties.ValidateCodeProperties;
import com.js.web.validate.code.email.DefaultEmailCodeSender;
import com.js.web.validate.code.email.EmailCodeSender;
import com.js.web.validate.code.image.ImageCodeGenerator;
import com.js.web.validate.code.sms.DefaultSmsCodeSender;
import com.js.web.validate.code.sms.SmsCodeSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 验证码相关的扩展点配置。配置在这里的bean，业务系统都可以通过声明同类型或同名的bean来覆盖安全
 */
@Configuration
public class ValidateCodeBeanConfig {

    @Autowired
    private ValidateCodeProperties validateCodeProperties;

    /**
     * 图片验证码图片生成器
     *
     * @return
     */
    @Bean
    @ConditionalOnMissingBean(name = "imageValidateCodeGenerator")
    public ValidateCodeGenerator imageValidateCodeGenerator() {
        ImageCodeGenerator codeGenerator = new ImageCodeGenerator();
        codeGenerator.setValidateCodeProperties(validateCodeProperties);
        return codeGenerator;
    }

    /**
     * 短信验证码发送器
     * @return
     */
    @Bean
    @ConditionalOnMissingBean(SmsCodeSender.class)
    public SmsCodeSender smsCodeSender() {
        return new DefaultSmsCodeSender();
    }

    /**
     * 邮箱验证码发送器
     * @return
     */
    @Bean
    @ConditionalOnMissingBean(EmailCodeSender.class)
    public EmailCodeSender emailCodeSender() {
        return new DefaultEmailCodeSender();
    }
}
