package com.js.web.controller.web;

import com.js.common.constant.Constant;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.PinYinUtils;
import com.js.common.util.ResultUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author liuh
 * @Description 汉字转拼音controller
 * @Date 2019/8/13
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1)
public class JsPinYinController {

    /**
     * 汉字转拼音
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsPinYin/convertToPinYin")
    public ResponseMessage convertToPinYin(@RequestParam String hanZi) {
        return ResultUtil.success(PinYinUtils.getHanziPinYin(hanZi.trim()));
    }
}
