package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.GenerateFileRecordReq;
import com.js.common.model.req.JsTradeFundReq;
import com.js.common.model.req.JsTradeListReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsPayTradeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 交易操作前后端交互controller
 * @Date 2019/6/6
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsPayTradeController {
    @Autowired
    JsPayTradeService jsPayTradeService;
    @Autowired
    private JsKycNaturalService jsKycNaturalService;

    /**
     * 查询交易明细列表
     * @Author liuh
     * @Date 2019/6/6
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/payTrade/tradeList")
    public ResponseMessage tradeList(JsTradeListReq jsTradeListReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsPayTradeService.tradeList(jsTradeListReq,optionalKycNaturalVO.get());
    }

    /**
     * 交易明细列表-交易详情
     * @Author liuh
     * @Date 2019/6/15
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/payTrade/tradeDetail")
    public ResponseMessage tradeDetail(@RequestParam TradeTypeEnum tradeType, @RequestParam String tradeId){
        return jsPayTradeService.tradeDetail(tradeType,tradeId);
    }

    /**
     * 查询资金明细列表
     * @Author liuh
     * @Date 2019/7/11
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/payTrade/fundDetailList")
    public ResponseMessage fundDetailList(JsTradeFundReq jsTradeFundReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsPayTradeService.fundDetailList(jsTradeFundReq,optionalKycNaturalVO.get());
    }

    /**
     * 资金明细列表-交易详情
     * @Author liuh
     * @Date 2019/7/12
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/payTrade/fundDetail")
    public ResponseMessage fundDetail(@RequestParam TradeTypeEnum tradeType,@RequestParam String tradeId){
        return jsPayTradeService.fundDetail(tradeType,tradeId);
    }

    /**
     * 获取生成文件列表数据
     * @Author liuh
     * @Date 2019/7/15
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/payTrade/generateFileRecordList")
    public ResponseMessage generateFileRecordList(@RequestParam GenerateFileType generateFileType,HttpServletRequest request,HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsPayTradeService.generateFileRecordList(generateFileType,optionalKycNaturalVO.get());
    }

    /**
     * 生成交易记录
     * @Author liuh
     * @Date 2019/7/15
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/payTrade/generateTradeRecord")
    public ResponseMessage generateTradeRecord(@RequestBody JsTradeListReq jsTradeListReq,HttpServletRequest request,HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsPayTradeService.generateTradeRecord(jsTradeListReq,optionalKycNaturalVO.get());
    }

    /**
     * 下载生成文件
     * @Author liuh
     * @Date 2019/7/22
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/payTrade/downloadGenerateRecord")
    public ResponseMessage downloadGenerateRecord(@RequestParam String id,@RequestParam GenerateFileType generateFileType,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        GenerateFileRecordReq generateFileRecordReq = new GenerateFileRecordReq();
        generateFileRecordReq.setId(id);
        generateFileRecordReq.setGenerateType(generateFileType);
        return jsPayTradeService.downloadGenerateRecord(generateFileRecordReq,response,optionalKycNaturalVO.get());
    }
}
