package com.js.web.controller.chinapnr;


import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.ChinapnrCallbackSerivce;
import com.js.web.utils.ServletUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;


/**
 * 汇付国际支付接口回调
 */
@Api("汇付国际支付回调")
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class ChinapnrCallbackController {

    @Autowired
    private ChinapnrCallbackSerivce chinapnrCallbackSerivce;


    private static String RESP_MSG ="<result>1</result>";
    private static String ERROR ="ERROR";

    /**
     * 汇付国际提现服务代发回调
     * @param request
     * @return
     * @throws Exception
     */
    @ApiOperation(value="汇付国际新版本代发回调",notes="汇付国际新版本代发回调")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/substitute/newCallback",
            consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE})
    public String substituteNewCallback(HttpServletRequest request){
        Map<String,String> map = ServletUtils.getRequestParameters(request);
        ResponseMessage responseMessage = chinapnrCallbackSerivce.substituteNewCallback(map);
        if(responseMessage.isSuccess()){
            return RESP_MSG;
        }else{
            return ERROR;
        }
    }

    /**
     * 汇付国际还款汇差服务费代发回调
     * @param request
     * @return
     * @throws Exception
     */
    @ApiOperation(value="汇付国际还款汇差服务费代发回调",notes="汇付国际还款汇差服务费代发回调")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/substitute/oldCallback",
            consumes = {MediaType.TEXT_XML_VALUE})
    public String substituteOldCallback(HttpServletRequest request)throws Exception{
        String wholeStr = ServletUtils.recieveData(request);
        ResponseMessage responseMessage = chinapnrCallbackSerivce.substituteOldCallback(wholeStr);
        if(responseMessage.isSuccess()){
            String resMsg = responseMessage.getData().toString(); //返回结果消息
            return resMsg;
        }else{
            return ERROR;
        }
    }

    /**
     * 汇付国际个人用户开户回调
     * @param request
     * @return
     * @throws Exception
     */
    @ApiOperation(value="汇付国际个人用户开户回调",notes="汇付国际个人用户开户回调")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/opendAccount/personal",
            consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE})
    public String opendAccountPersonal(HttpServletRequest request){
         Map<String,String> map = ServletUtils.getRequestParameters(request);
        ResponseMessage responseMessage = chinapnrCallbackSerivce.opendAccountPersonal(map);
        if(responseMessage.isSuccess()){
            return RESP_MSG;
        }else{
            return ERROR;
        }
    }

    /**
     * 汇付国际企业用户开户回调
     * @param request
     * @return
     * @throws Exception
     */
    @ApiOperation(value="汇付国际企业用户开户回调",notes="汇付国际企业用户开户回调")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/opendAccount/enterprise",
            consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE})
    public String opendAccountEnterprise(HttpServletRequest request){
        Map<String,String> map = ServletUtils.getRequestParameters(request);
        ResponseMessage responseMessage = chinapnrCallbackSerivce.opendAccountEnterprise(map);
        if(responseMessage.isSuccess()){
            return RESP_MSG;
        }else{
            return ERROR;
        }
    }

    @ApiOperation(value="汇付国际交易明细备案回调",notes="汇付国际交易明细备案回调")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/chinaPNRPayTransactionDetails/transactionDetailsCallback",
            consumes = {MediaType.TEXT_XML_VALUE})
    public String transactionDetailsCallback(HttpServletRequest request)throws Exception{
        String wholeStr = ServletUtils.recieveData(request);
        ResponseMessage responseMessage = chinapnrCallbackSerivce.transactionDetailsCallback(wholeStr);
        if(responseMessage.isSuccess()){
            String resMsg = responseMessage.getData().toString(); //返回结果消息
            return resMsg;
        }else{
            return ERROR;
        }
    }

    /**
     * 汇付结汇回调
     * @param request
     * @return
     * @throws Exception
     */
    @ApiOperation(value="汇付结汇回调",notes="汇付结汇回调")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/substitute/exchangeCallback",
            consumes = {MediaType.TEXT_XML_VALUE})
    public String exchangeCallback(HttpServletRequest request)throws Exception{
        String wholeStr = ServletUtils.recieveData(request);
        ResponseMessage responseMessage = chinapnrCallbackSerivce.exchangeCallback(wholeStr);
        if(responseMessage.isSuccess()){
            String resMsg = responseMessage.getData().toString(); //返回结果消息
            return resMsg;
        }else{
            return ERROR;
        }
    }
}
