package com.js.web.validate.code.sms;

import com.alibaba.fastjson.JSONObject;
import com.js.common.JsException.LogicException;
import com.js.common.constant.CommonConstant;
import com.js.common.enums.ResultEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

/**
 * @Author yjzhao
 * @Description 发送手机验证码
 * @Date 2019/4/8 15:11
 * @Param
 * @return
 **/
@Slf4j
public class DefaultSmsCodeSender implements SmsCodeSender {
    @Value("${jsweb.sms.url}")
    private String sendSmsUrl;

    @Override
    public void send(String mobile, String code) {
        log.info("调用短信验证码发送器(EmailCodeSender)");
        RestTemplate restTemplate = new RestTemplate();
        JSONObject jsonObjectParams = new JSONObject();
        jsonObjectParams.put("templateType", CommonConstant.SEND_SMS_TEMPLATE_TYPE);
        jsonObjectParams.put("templateInnerId",CommonConstant.SEND_SMS_TEMPLATE_INNER_ID);
        jsonObjectParams.put("mobile",mobile);
        JSONObject subParams = new JSONObject();
        subParams.put("code",code);
        jsonObjectParams.put("data",subParams);
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(jsonObjectParams, header);
        JSONObject jsonObject = restTemplate.postForObject(sendSmsUrl, httpEntity, JSONObject.class);
        Boolean success = Boolean.valueOf(jsonObject.get("success").toString());
        if(success){
            log.info("向手机:{}, 发送短信验证码:{}, 返回:{}" ,mobile ,code ,success);
        }else{
            log.error("向手机:{}, 发送短信验证码:{}, 返回:{}" ,mobile ,code ,jsonObject.getString("message"));
            throw LogicException.le(ResultEnum.SEND_VALIDATE_CODE_ERROR);
        }
    }
}
