package com.js.web.utils;

import com.js.common.JsException.LogicException;
import com.js.common.enums.ResultEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.HibernateValidator;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.Set;

@Slf4j
public class ValidatorUtil {
    public static void paramsValid(Object object){
        String validMessage = "";
        //初始化检查器。
        ValidatorFactory validatorFactory = Validation.byProvider(HibernateValidator.class )
                .configure()
                .failFast( false )
                .buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        //检查object
        Set<ConstraintViolation<Object>> set = validator.validate(object);
        //循环set，获取检查结果
        for(ConstraintViolation<Object> voset : set){
            validMessage = validMessage + voset.getMessage() +";";
        }
        if(!StringUtils.isEmpty(validMessage)){
            //抛出业务异常
            log.error("验证結果:{}",validMessage);
            throw LogicException.le(ResultEnum.NO_MUST_PARAM_ERROR);
        }
    }
}
