package com.js.web.service.impl;

import com.js.api.jspay.service.ApiKycSecurityService;
import com.js.common.constant.Constant;
import com.js.common.model.req.KycSecurityReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycSecurityService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

/**
 * @Description: 安全设置接口实现
 * @Author: liuh
 * @Create: 2019-07-8
 **/
@Slf4j
@Service
public class JsKycSecurityServiceImpl implements JsKycSecurityService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0
    )
    ApiKycSecurityService apiKycSecurityService;

    @Override
    public ResponseMessage saveSecurityByKyc(KycSecurityReq kycSecurityReq, KycNaturalVO kycNaturalVO) {
        return apiKycSecurityService.saveSecurityByKyc(kycSecurityReq,kycNaturalVO);
    }

    @Override
    public ResponseMessage findsSecurityByKyc(KycNaturalVO kycNaturalVO) {
        return apiKycSecurityService.findSecurityByKyc(kycNaturalVO);
    }
}
