package com.js.web.controller.vat;

import com.js.common.constant.Constant;
import com.js.common.enums.CertiFileType;
import com.js.common.enums.FileResourceType;
import com.js.common.enums.FileType;
import com.js.common.model.req.JsPaySupplierBatReq;
import com.js.common.model.req.JsPaySupplierInfoReq;
import com.js.common.model.req.JsPaySupplierUserInfoReq;
import com.js.common.model.req.KycShowStoreReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsPaySupplierService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
@Slf4j
public class JsPaySupplierController {

    @Autowired
    private JsPaySupplierService jsPaySupplierService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 供应商付款 余额列表
     * @Author liwm
     * @Date 2019/7/7
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsPaySupplier/queryAvailableList")
    public ResponseMessage queryAvailableList(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return  jsPaySupplierService.queryAvailableList(optionalKycNaturalVO.get());
    }

    /**
     * vat 协议是否展示
     * @Author liwm
     * @Date 2019/6/27
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsPaySupplier/queryTreaty")
    public ResponseMessage queryTreaty(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        String kycNaturalId = optionalKycNaturalVO.get().getId();
        return  jsPaySupplierService.queryTreaty(kycNaturalId);
    }

    /**
     * vat 协议展示确认
     * @Author liwm
     * @Date 2019/6/27
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsPaySupplier/submitTreaty")
    public ResponseMessage submitTreaty(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        String kycNaturalId = optionalKycNaturalVO.get().getId();
        return  jsPaySupplierService.submitTreaty(kycNaturalId);
    }

    /**
     * js我的店铺列表
     * @Author liwm
     * @Date 2019/7/2
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsPaySupplier/storeList")
    public ResponseMessage storeList(@RequestBody KycShowStoreReq kycShowStoreReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        kycShowStoreReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsPaySupplierService.storeList(kycShowStoreReq);
    }

    /**
     * 供应商付款 收款人列表
     * @Author liwm
     * @Date 2019/7/7
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsPaySupplier/queryRcvList")
    public ResponseMessage queryRcvList( @RequestBody String kycNaturalId) throws Exception{

        return  jsPaySupplierService.queryRcvList(kycNaturalId);
    }

    /**
     * 供应商付款 添加收款人
     * @Author liwm
     * @Date 2019/7/7
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsPaySupplier/addSupplierRcv")
    public ResponseMessage addSupplierRcv(@Valid @RequestBody JsPaySupplierUserInfoReq jsPaySupplierUserInfoReq, HttpServletRequest request, HttpServletResponse response)throws Exception {
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsPaySupplierService.addSupplierRcv(jsPaySupplierUserInfoReq,optionalKycNaturalVO.get());
    }

    /**
     * 供应商付款 提交
     * @Author liwm
     * @Date 2019/7/9
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsPaySupplier/paySupplierSubmit")
    public ResponseMessage paySupplierSubmit(@Valid @RequestBody JsPaySupplierBatReq jsPaySupplierBatReq , HttpServletRequest request, HttpServletResponse response) throws Exception {
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsPaySupplierService.paySupplierSubmit(jsPaySupplierBatReq,optionalKycNaturalVO.get());
    }

    /**
     * 上传文件
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsPaySupplier/upFile")
    public ResponseMessage upFileTest(MultipartFile file,
                                      FileType fileType,
                                      FileResourceType fileResourceType, CertiFileType certiFileType,String currFlag) {
        return jsPaySupplierService.uploadFile(file, fileType, fileResourceType,certiFileType,currFlag);
    }

    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsPaySupplier/upload")
    public String upload(@RequestParam("file") MultipartFile file) {
        if (file.isEmpty()) {
            return "上传失败，请选择文件";
        }
        String fileName = file.getOriginalFilename();
        String filePath = "D:/temp/";
        File dest = new File(filePath + fileName);
        try {
            file.transferTo(dest);
            log.info("上传成功");

            return "上传成功";
        } catch (IOException e) {
            log.error(e.toString(), e);
        }
        return "上传失败！";
    }

}
