package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.model.req.CertiMainLandPersonalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycCertiMainLandPersonalService;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Date;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 大陆个人前后端交互controller
 * @Date 2019/5/18
 * @Param
 * @return
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class CertiMainlandPersonalController {

    @Autowired
    private JsKycCertiMainLandPersonalService jsKycCertiMainLandPersonalService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 实名认证-大陆个人保存接口
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/certiMainLand/addPersonal",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage certiMainLandPersonalAdd(@Valid @RequestBody CertiMainLandPersonalReq certiMainLandPersonalReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        ResponseMessage responseMessage = jsKycCertiMainLandPersonalService.certiMainLandPersonalAdd(certiMainLandPersonalReq,optionalKycNaturalVO.get());
        return responseMessage;
    }

    /**
     * 获取大陆实名信息
     * @Author liuh
     * @Date 2019/8/5
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/certi/getCertiInfo")
    public ResponseMessage getCertiInfo(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        ResponseMessage responseMessage = jsKycCertiMainLandPersonalService.getCertiInfoDetail(optionalKycNaturalVO.get());
        return responseMessage;
    }
}
