package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.model.req.CertiMainLandCompanyReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycCertiMainLandCompanyService;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 大陆企业前后端交互controller
 * @Date 2019/5/18
 * @Param
 * @return
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE},
        consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class CertiMainlandCompanyController {

    @Autowired
    private JsKycCertiMainLandCompanyService jsKycCertiMainLandCompanyService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 实名认证-大陆企业保存接口
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/certiMainLand/addCompany")
    public ResponseMessage certiMainLandCompanyAdd(@Valid @RequestBody CertiMainLandCompanyReq certiMainLandCompanyReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycCertiMainLandCompanyService.certiMainLandCompanyAdd(certiMainLandCompanyReq,optionalKycNaturalVO.get());
    }
}
