package com.js.web.validate.code.sms;


import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.js.common.model.req.ValidateCodeReq;
import com.js.web.properties.ValidateCodeProperties;
import com.js.web.validate.code.ValidateCode;
import com.js.web.validate.code.ValidateCodeGenerator;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.ServletWebRequest;

import java.time.LocalDateTime;
import java.time.ZoneOffset;

/**
 * 短信验证码模板
 */
@Component("smsValidateCodeGenerator")
public class SmsCodeGenerator implements ValidateCodeGenerator {

    @Autowired
    private ValidateCodeProperties validateCodeProperties;

    @Override
    public ValidateCode generate(ValidateCodeReq validateCodeReq) {
        String code = RandomStringUtils.randomNumeric(validateCodeProperties.getSms().getLength());
        Long markLong = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        int expireIn = validateCodeProperties.getSms().getExpireIn();
        return new ValidateCode(code, Convert.toStr(markLong), expireIn,validateCodeReq.getPhoneNo());
    }
}
