package com.js.web.service;


import com.js.common.enums.CertiFileType;
import com.js.common.enums.FileResourceType;
import com.js.common.enums.FileType;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface JsPaySupplierService {

    /**
     * 供应商付款 收款人列表
     * @Author liwm
     * @Date 2019/7/7
     */
    ResponseMessage queryRcvList(String kycNaturalId);

    ResponseMessage queryTreaty(String kycNaturalId);
    ResponseMessage submitTreaty(String kycNaturalId);

    /** 店铺列表
     * @Author liwm
     * @Date 2019/7/2
     **/
    ResponseMessage storeList(KycShowStoreReq kycShowStoreReq);
    /**
     * 供应商付款 余额列表
     * @Author liwm
     * @Date 2019/7/7
     */
    ResponseMessage queryAvailableList(KycNaturalVO kycNaturalVO);

    /**
     * 供应商付款 文件上传
     * @Author liwm
     * @Date 2019/7/7
     */
    ResponseMessage uploadFile(MultipartFile file, FileType fileType, FileResourceType fileResourceType, CertiFileType certiFileType,String currFlag);
    /**
     * 供应商付款 提交
     * @Author liwm
     * @Date 2019/7/9
     */
    ResponseMessage paySupplierSubmit(JsPaySupplierBatReq jsPaySupplierBatReq , KycNaturalVO kycNaturalVO);


    ResponseMessage addSupplierRcv(JsPaySupplierUserInfoReq jsPaySupplierUserInfoReq,KycNaturalVO kycNaturalVO);
}
