package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.KycCertiContactsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 与寻汇调用前后端交互controller
 * @Date 2019/5/21
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
@Slf4j
public class KycCertiContactsController {
    @Autowired
    KycCertiContactsService kycCertiContactsService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * @Description  添加联系人
     * @Author liuh
     * @Date 2019/8/15
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/kycCertiContacts/addContacts",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage addContacts(@Valid @RequestBody KycCertiContactsReq kycCertiContactsReq,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return kycCertiContactsService.saveKycCertiContacts(kycCertiContactsReq,optionalKycNaturalVO.get());
    }

    /**
     * @Description  查找联系人
     * @Author liuh
     * @Date 2019/8/15
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/kycCertiContacts/getContacts")
    public ResponseMessage getContacts(@RequestParam String kycContractsId,@RequestParam String kycCertiId){
        return kycCertiContactsService.getKycCertiContacts(kycContractsId,kycCertiId);
    }
}
