package com.js.web.config;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.js.common.JsException.LogicException;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.util.JjwtUtil;
import com.js.common.util.RedisUtil;
import com.js.common.util.ResponseUtil;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

/**
 * Title: SessionCofig
 * Description: 登陆webMvcconfigurer 自定义配置
 *
 * @author ligang
 * @created 2018/10/24 15:01
 */
@Configuration
public class SessionCofig implements WebMvcConfigurer {

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private JsKycNaturalService jsKycNaturalService;

    /**
     * @Author yjzhao
     * @Description 登陆拦截
     * @Date 2019/5/15 19:45
     * @Param [registry]
     * @return void
     **/
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new SecurityInterceptor())
                .addPathPatterns("/**")
                ////排除拦截
                .excludePathPatterns(Constant.ApiPath.V1 + Constant.ApiLoginAuth.ANON + "/**")
                .excludePathPatterns("/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**");

    }


    @Configuration
    public class SecurityInterceptor implements HandlerInterceptor {
        @Override
        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            Optional<KycNaturalVO> kycNaturalVOOp = jsKycNaturalService.findKycNaturalVOByWebToken(request, response);
            KycNaturalVO kycNaturalVO = kycNaturalVOOp.get();
            if (!kycNaturalVOOp.isPresent()) {
                throw LogicException.le(ResultEnum.USER_TOKEN_FAILURE);
            }
            String kycNaturalVOStr =  JSON.toJSONString(kycNaturalVO);
            redisUtil.setex(Constant.REDIS_JS_WEB_USER + kycNaturalVO.getId(), Constant.LOGIN_TIMEOUT, kycNaturalVOStr);

            //Optional<String> userIdOp = JjwtUtil.getTokenValue(Constant.TOKEN_KEY_NAME, request);
            //if (!userIdOp.isPresent()) {
            //    throw LogicException.le(ResultEnum.USER_TOKEN_FAILURE);
            //}
            //String userId = userIdOp.get();
            //String userJson = redisUtil.get(Constant.REDIS_JS_WEB_USER + userId);
            //
            //if (StrUtil.isEmpty(userJson)) {
            //    throw LogicException.le(ResultEnum.USER_TOKEN_FAILURE);
            //}
            //
            //redisUtil.setex(Constant.REDIS_JS_WEB_USER + userId, Constant.LOGIN_TIMEOUT, userJson);
            return true;
        }

    }

}
