package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jsloan.service.ApiJsLoanRepaymentService;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.model.req.RepaymentLoanReq;
import com.js.common.model.req.RepaymentOperationReq;
import com.js.common.model.req.RepaymentTrialReq;
import com.js.common.model.req.SunrateTradePriceReq;
import com.js.common.model.vo.JsPaySunrateTradeQueryPriceVo;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsLoanRepaymentService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class JsLoanRepaymentServiceImpl implements JsLoanRepaymentService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsLoanRepaymentService apiJsLoanRepaymentService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private
    ApiSunrateTradePriceService apiSunrateTradePriceService;

    @Override
    public ResponseMessage detailed(String loanNo) {

        return apiJsLoanRepaymentService.detailed(loanNo);
    }

    @Override
    public ResponseMessage loanSituation(RepaymentLoanReq repaymentLoanReq) {

        return apiJsLoanRepaymentService.loanSituation(repaymentLoanReq);
    }

    @Override
    public ResponseMessage operation(RepaymentOperationReq repaymentOperationReq) {
        return apiJsLoanRepaymentService.operation(repaymentOperationReq);
    }

    @Override
    public ResponseMessage trial(RepaymentTrialReq repaymentTrialReq){
        return apiJsLoanRepaymentService.trial(repaymentTrialReq);
    }

    /**
     * 查询店铺账户
     * @param kycNaturalId
     * @return
     */
    @Override
    public ResponseMessage queryStoreAccount(String kycNaturalId) {
        ResponseMessage  querystoreAccountMessage = apiJsLoanRepaymentService.queryStoreAccount(kycNaturalId);
        if(!querystoreAccountMessage.isSuccess()){
            log.info("查询到店铺账户信息报错 .. keyNaturalId:{}",kycNaturalId);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到店铺账户信息报错");
        }
        List<Map<String,Object>> canWithdrawStoreList = (List<Map<String,Object>>)querystoreAccountMessage.getData();
        if(null == canWithdrawStoreList){
            log.info("查询到店铺账户信息未空 .. keyNaturalId:{}",kycNaturalId);
            return ResultUtil.success(ResultEnum.SUCCESS.getCode(),"查询到店铺账户信息未空");
        }
        SunrateTradePriceReq sunrateTradePriceReq = new SunrateTradePriceReq();
        sunrateTradePriceReq.setBuyCur(CommonConstant.TRADE_CURRENCY_CNH);//离岸人民币币种
        sunrateTradePriceReq.setTxnMode(CommonConstant.TXN_MODE_SELL);
        sunrateTradePriceReq.setBrowserIP("12345678"); //默认browserIP
        canWithdrawStoreList.stream().forEach(map -> {
            map.put("currencySymbol", SiteEnum.getByCurrency(map.get("curId").toString()).getCurrencySymbol());
            sunrateTradePriceReq.setOrgCode(map.get("orgCode").toString());
            sunrateTradePriceReq.setSellCur(map.get("curId").toString());
            sunrateTradePriceReq.setTxnAmt(new BigDecimal(map.get("currentAmt").toString()));
            //合作方 -> 寻汇 询价
            ResponseMessage responseMessage = apiSunrateTradePriceService.xhTradeQueryPrice(sunrateTradePriceReq);
            if(responseMessage.isSuccess()){
                JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
                JsPaySunrateTradeQueryPriceVo jsPaySunrateTradeQueryPriceVo = jsonObject.toJavaObject(JsPaySunrateTradeQueryPriceVo.class);
                map.put("accountCNYTotalAmt",jsPaySunrateTradeQueryPriceVo.getBuyAmt()); //店铺约等于人民币金额
            }
        });
        log.info("查询可提现账户信息结束:条数{}", CollectionUtils.isEmpty(canWithdrawStoreList) ? 0 : canWithdrawStoreList.size());
        return ResultUtil.success(canWithdrawStoreList,ResultEnum.SUCCESS);
    }

}
