package com.js.web.service;

import com.js.common.enums.RegisterType;
import com.js.common.model.req.KycStoreLoanReq;
import com.js.common.model.vo.common.ResponseMessage;

/**
 * @Author zhouyngsheng
 * @Description 店铺贷入口信息
 * @Date 2019/8/1
 **/
public interface JsStoreLoanService {

    /**
     * 获取店铺信息
     * @param kycStoreLoanReq
     * @return
     */
    ResponseMessage getStoreLoanList(KycStoreLoanReq kycStoreLoanReq);

    /**
     * 店铺贷-入口基本信息查询
     * @param kycNatural
     * @return
     */
    ResponseMessage condition(String kycNatural);

    /**
     * KEY信息查询
     * @param kycNaturalId
     * @param registerType
     * @return
     */
    ResponseMessage getKeyNatural(String kycNaturalId, RegisterType registerType);
}
