package com.js.web.service.impl;

import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.*;
import com.js.api.jspay.service.chinapnr.ChinaPNRTransactionDetailsService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.constant.RegexConstant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.RedisUtil;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsPayVatPaymentInfoService;
import com.js.web.validate.code.ValidateCodeException;
import com.js.web.validate.code.ValidateCodeProcessorHolder;
import com.js.web.validate.code.ValidateCodeType;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Slf4j
@Service
public class JsPayVatPaymentInfoServiceImpl implements JsPayVatPaymentInfoService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPayVatPaymentInfoService apiJsPayVatPaymentInfoService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPayStationOrganInfoService apiJsPayStationOrganInfoService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPayUserStationInfoService apiJsPayUserStationInfoService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycStoreService apiKycStoreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsTradeService apiJsTradeService;
    @Autowired
    private ValidateCodeProcessorHolder validateCodeProcessorHolder;
    @Autowired
    RedisUtil redisUtil;
    @Value("${jsweb.errormaxcount.smsmaxcount}")
    private Integer maxCount;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsUserTreatyService apiJsUserTreatyService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsPayTradeService apiJsPayTradeService;

    @Override
    public ResponseMessage queryRcvList(String kycNaturalId) {
        // 查询收款人列表
        return apiJsPayVatPaymentInfoService.queryRcvList(kycNaturalId);
    }

    @Override
    public ResponseMessage queryTreaty(String kycNaturalId) {
        // 查询协议
        return apiJsUserTreatyService.queryTreaty(kycNaturalId,"0");
    }

    @Override
    public ResponseMessage submitTreaty(String kycNaturalId) {
        // 协议查看确认
        return apiJsUserTreatyService.submitTreaty(kycNaturalId,"0");
    }

    @Override
    public ResponseMessage storeList(KycShowStoreReq kycShowStoreReq) {
        // 根据站点币种查询店铺列表
        return apiKycStoreService.queryStoreListByCurr(kycShowStoreReq);
    }

    private ResponseMessage checkValidate(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq){
        log.info("VAT缴税提交，第1步验证码校验" + jsPayVatPaymentInfoReq.getPhone());
        try {
            KycBankReq kycBankReq = new KycBankReq();
            kycBankReq.setMarkStr(jsPayVatPaymentInfoReq.getMarkStr());
            kycBankReq.setPhone(jsPayVatPaymentInfoReq.getPhone());
            kycBankReq.setSmsCode(jsPayVatPaymentInfoReq.getSmsCode());
            ValidateCodeReq validateCodeReq = regiserReqConvertToValidateCodeReq(kycBankReq);
            validateCodeProcessorHolder.findValidateCodeProcessor("sms").validate(validateCodeReq, null);
        } catch (ValidateCodeException exception) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),exception.getMessage());
        } catch (Exception e) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),ResultEnum.VALIDATE_CODE_ERROT.getMsg());
        }
        return ResultUtil.success();
    }
    public ResponseMessage payVatPayment(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq , KycNaturalVO kycNaturalVO) {
        log.info("VAT缴税提交start:" + JSON.toJSONString(jsPayVatPaymentInfoReq));
        String kycNaturalId = kycNaturalVO.getId();
        jsPayVatPaymentInfoReq.setKycNaturalId(kycNaturalId);
        jsPayVatPaymentInfoReq.setKycNaturalName(kycNaturalVO.getCertificationName());
        ResponseMessage responseMessage = null;
        // 验证码校验
//        ResponseMessage responseMessage = checkValidate(jsPayVatPaymentInfoReq);
//        if(!responseMessage.isSuccess()){
//            return responseMessage;
//        }
        jsPayVatPaymentInfoReq.setCreateId(kycNaturalVO.getId());
//        jsPayVatPaymentInfoReq.setCreateName(kycNaturalVO.getCertificationName());
        RegisterType registerType = kycNaturalVO.getRegisterType();
        String orgCode = apiSunrateTradePriceService.findOrgCode(kycNaturalId,registerType);
        log.info("缴税人社会组织机构代码为："+ orgCode );
        jsPayVatPaymentInfoReq.setOrgCode(orgCode);
        jsPayVatPaymentInfoReq.setSortCode(orgCode);
        log.info("VAT缴税提交，第2步查询是否需要添加受益人");
        String beneficiaryId = jsPayVatPaymentInfoReq.getBeneficiaryId();
        if(StringUtils.isBlank(beneficiaryId)){
            JsPayUserStationInfoVO jsPayUserStationInfoVO = apiJsPayUserStationInfoService.queryVatStationInfo(jsPayVatPaymentInfoReq);
            jsPayVatPaymentInfoReq.setTaxStationId(jsPayUserStationInfoVO.getTaxStationId());
            jsPayVatPaymentInfoReq.setBeneficiaryId(jsPayUserStationInfoVO.getBeneficiaryId());
        }
        String beneficiaryStatus = "";
        // 验证 手工填写的机构信息是否已登记
        if(StringUtils.isNotBlank(beneficiaryId)){ // 已登记过，验证受益人是否通过
            beneficiaryStatus = apiJsPayUserStationInfoService.queryVatStationStatus(beneficiaryId);
        }
        String sumbitStatus = StatusEnum.TRADEUNKNOWN.getEnumName();
        // 首次添加缴税机构  缴税机构审核未通过
        if(StringUtils.isBlank(beneficiaryId) || CommonConstant.XH_BENEFICIARY_NOT_PASS.equals(beneficiaryStatus) || StringUtils.isEmpty(beneficiaryStatus)){
            //添加受益人
            responseMessage = addBeneficiary(jsPayVatPaymentInfoReq,kycNaturalVO);
                if(responseMessage.isSuccess()){
                JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
                jsPayVatPaymentInfoReq.setBeneficiaryId(jsonObject.getString("beneficiaryId"));
                beneficiaryStatus = jsonObject.getString("beneficiaryStatus");
                log.info("VAT缴税提交，第3步添加受益人成功，beneficiaryId：{}，beneficiaryStatus：{}",beneficiaryId , beneficiaryStatus);
            }else{
//                sumbitStatus = StatusEnum.AUDITFAIL.getEnumName();
                return responseMessage;
            }
            // 添加缴税机构
            responseMessage = insertVatStationInfo(jsPayVatPaymentInfoReq);
            log.info("VAT缴税提交，第4步添加缴税机构 getTaxStationId=" + jsPayVatPaymentInfoReq.getTaxStationId());
            if(!responseMessage.isSuccess()){
//                sumbitStatus = StatusEnum.AUDITFAIL.getEnumName();
                return responseMessage;
            }
            // 添加用户缴税机构关系
            addPayUserStationInfo(jsPayVatPaymentInfoReq);
            sumbitStatus = StatusEnum.AUDITING.getEnumName();
        }
        // 缴税机构审核通过
        if(CommonConstant.XH_BENEFICIARY_PASS.equals(beneficiaryStatus)){
            log.info("VAT缴税提交，第3步受益人审核通过，发市价锁汇交易.");
            // 记录VAT缴税记录 + 调用寻汇市价锁汇交易接口
            responseMessage = apiJsPayVatPaymentInfoService.addVatPayTrade(jsPayVatPaymentInfoReq,kycNaturalVO);
            if(responseMessage.isSuccess()){
                addTradeRecord(jsPayVatPaymentInfoReq,ProcessStatusEnum.TRADE_PROCESSEDING.toString());
                jsPayVatPaymentInfoReq =(JsPayVatPaymentInfoReq)responseMessage.getData();
                jsPayVatPaymentInfoReq.setStatus(StatusEnum.TRADEUNKNOWN.queryEnumCode());
                log.info("VAT缴税提交，市价锁汇交易成功，寻汇流水号：{}",jsPayVatPaymentInfoReq.getTxnNo());
                apiJsPayVatPaymentInfoService.updatePayVatPaymentInfo(jsPayVatPaymentInfoReq,jsPayVatPaymentInfoReq.getId());
                return ResultUtil.success(sumbitStatus,ResultEnum.SUCCESS);
            }else{
                addTradeRecord(jsPayVatPaymentInfoReq,ProcessStatusEnum.TRADE_PROCESSED_FAILURE.toString());
                return responseMessage;
            }
        }
        // 添加VAT缴税 记录 对于非审核通过的受益人
        addVatPayTradeForNoPass(jsPayVatPaymentInfoReq);
        addTradeRecord(jsPayVatPaymentInfoReq,ProcessStatusEnum.TRADE_UNPROCESSED.toString());
        return ResultUtil.success(sumbitStatus,ResultEnum.SUCCESS);
    }

//    public static void main(String[] args) {
//        JsPayVatPaymentInfoReq js = new JsPayVatPaymentInfoReq();
//        js.setTaxStationId("123");
//        js.setBeneficiaryId("456");
//        ResponseMessage re = aa(js);
//        JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq =(JsPayVatPaymentInfoReq)re.getData();
//        System.out.println(jsPayVatPaymentInfoReq.getTaxStationId()+jsPayVatPaymentInfoReq.getBeneficiaryId()+jsPayVatPaymentInfoReq.getLockNo());
//    }
//    public static ResponseMessage aa(JsPayVatPaymentInfoReq js) {
//        js.setLockNo("789");
//        return ResultUtil.success(js);
//    }


    @Override
    public ResponseMessage beneficiayAuditNotice(String beneficiaryId , String beneficiaryStatus){  // 缴税机构(受益人)审核通知
        if(beneficiaryId == null){
            log.error("寻汇受益人审核通过回调失败，beneficiaryId =null,beneficiaryStatus ：{}",beneficiaryStatus);
            return ResultUtil.error(ResultEnum.ERROR);
        }
        ResponseMessage responseMessage = apiJsPayVatPaymentInfoService.queryJsPayVatPaymentInfoReqList(beneficiaryId);
        if(!responseMessage.isSuccess()){
            return responseMessage;
        }
        List<JsPayVatPaymentInfoReq> jsPayVatPaymentInfoReqs = (List<JsPayVatPaymentInfoReq>) JSONArray.parseArray
                (JSON.toJSONString(responseMessage.getData()), JsPayVatPaymentInfoReq.class);
        if(CommonConstant.XH_BENEFICIARY_PASS.equals(beneficiaryStatus)){
            List<String> succIds = new ArrayList<>();
            List<String> failIds = new ArrayList<>();
            for(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq : jsPayVatPaymentInfoReqs) {
                KycNaturalVO kycNaturalVO = new KycNaturalVO();
                kycNaturalVO.setId(jsPayVatPaymentInfoReq.getKycNaturalId());
                jsPayVatPaymentInfoReq.setStatus(StatusEnum.AUDITSUCC.queryEnumCode());
                log.info("VAT缴税提交受益人{}审核通过回调，发市价锁汇交易.",beneficiaryId);
                // 记录VAT缴税记录 + 调用寻汇市价锁汇交易接口
                responseMessage = apiJsPayVatPaymentInfoService.beneficiayAuditNoticeVatPayTrade(jsPayVatPaymentInfoReq,kycNaturalVO);
                if(responseMessage.isSuccess()){
                    jsPayVatPaymentInfoReq =(JsPayVatPaymentInfoReq)responseMessage.getData();
//                    JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
//                    jsPayVatPaymentInfoReq = jsonObject.toJavaObject(JsPayVatPaymentInfoReq.class);
                    jsPayVatPaymentInfoReq.setStatus(StatusEnum.TRADEUNKNOWN.queryEnumCode());
                    log.info("VAT缴税提交，市价锁汇交易成功，寻汇流水号：{}",jsPayVatPaymentInfoReq.getTxnNo());
                    apiJsPayVatPaymentInfoService.updatePayVatPaymentInfo(jsPayVatPaymentInfoReq,jsPayVatPaymentInfoReq.getId());
                    succIds.add(jsPayVatPaymentInfoReq.getId());
                }else{
                    log.info("VAT缴税提交，市价锁汇交易失败，jsPayVatPaymentInfoReq流水号：{}",jsPayVatPaymentInfoReq.getId());
                    jsPayVatPaymentInfoReq.setStatus(StatusEnum.RATETRADEFAIL.queryEnumCode());
                    apiJsPayVatPaymentInfoService.updatePayVatPaymentInfo(jsPayVatPaymentInfoReq,jsPayVatPaymentInfoReq.getId());
                    failIds.add(jsPayVatPaymentInfoReq.getId());
                }
            }
            updateTradeRecord(succIds,ProcessStatusEnum.TRADE_PROCESSEDING.toString());
            updateTradeRecord(failIds,ProcessStatusEnum.TRADE_PROCESSED_FAILURE.toString());
        }else{
            List<String> ids = jsPayVatPaymentInfoReqs.stream().map(JsPayVatPaymentInfoReq::getId).collect(Collectors.toList());
            apiJsPayVatPaymentInfoService.updateStatusById(ids ,StatusEnum.AUDITFAIL.toString());
            updateTradeRecord(ids,ProcessStatusEnum.TRADE_PROCESSED_FAILURE.toString());
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private ResponseMessage updateTradeRecord( List<String> ids,String status){

        return apiJsTradeService.updateTradeRecord(ids,status);
    }

    private ResponseMessage addTradeRecord(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq,String status){
        log.info("VAT缴税提交，第4步记录交易流水总表.");
        JsTradeVO jsTradeVO = new JsTradeVO();
        jsTradeVO.setTradeDts(new Date());
        jsTradeVO.setKycNaturalId(jsPayVatPaymentInfoReq.getKycNaturalId());
        jsTradeVO.setTradeNo(jsPayVatPaymentInfoReq.getId());
        jsTradeVO.setAccType("1");
        jsTradeVO.setTradeType(TradeTypeEnum.TRADE_PAYMENT.toString());
        jsTradeVO.setInAcct(CountryCodeEnum.ENGLAND.getEnumCode().equals(jsPayVatPaymentInfoReq.getTaxStationCountry())?jsPayVatPaymentInfoReq.getBankCardNo():jsPayVatPaymentInfoReq.getIban());
        jsTradeVO.setInAcctName(jsPayVatPaymentInfoReq.getCusName());
        jsTradeVO.setInAmt(jsPayVatPaymentInfoReq.getVatPayAmt());
//        jsTradeVO.setOutAcct(jsPayVatPaymentInfoReq.get);
//        jsTradeVO.setOutAcctName();
        jsTradeVO.setOutAmt(jsPayVatPaymentInfoReq.getPayAmt());
        jsTradeVO.setTradeSubType(TradeSubTypeEnum.VAT_PAYMENT.toString());
        jsTradeVO.setCurId(jsPayVatPaymentInfoReq.getVatPayCur());
        jsTradeVO.setTradeAmt(jsPayVatPaymentInfoReq.getVatPayAmt());
        jsTradeVO.setProcessStatus(status);

        JsPayTradeReq jsPayTradeReq = new JsPayTradeReq();
        BeanUtils.copyProperties(jsTradeVO,jsPayTradeReq);
        jsPayTradeReq.setKycSunrateStoreId(jsPayVatPaymentInfoReq.getKycSunrateStoreId());
//        jsPayTradeReq.setSubstituteDetailId("");
        jsPayTradeReq.setLockNo(jsPayVatPaymentInfoReq.getLockNo());
        jsPayTradeReq.setTxnNo(jsPayVatPaymentInfoReq.getTxnNo());
        jsPayTradeReq.setKycSunrateBankId(jsPayVatPaymentInfoReq.getKycSunrateBankId());
//        jsPayTradeReq.setUserAcctCurrAmt("");
//        jsPayTradeReq.setUserAcctBorrowAmt("");
//        jsPayTradeReq.setInAcctAvailableAmt("");
//        jsPayTradeReq.setOutAcctAvailableAmt("");

        apiJsPayTradeService.jsPayTradeAdd(jsPayTradeReq);

        return apiJsTradeService.addTradeRecord(jsTradeVO);
    }


    /**
     * 添加受益人
     * @param jsPayVatPaymentInfoReq 受益人信息
     * @param kycNaturalVO 用户信息
     * @return
     */
    private ResponseMessage addBeneficiary(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, KycNaturalVO kycNaturalVO){
        log.info("添加受益人，组织接口参数数据 start:");
        KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq = new KycSunrateBeneficiaryReq();
        kycSunrateBeneficiaryReq.setOrgCode(jsPayVatPaymentInfoReq.getOrgCode());
        kycSunrateBeneficiaryReq.setBankName(jsPayVatPaymentInfoReq.getBankName());
//        String taxStationType = jsPayVatPaymentInfoReq.getTaxStationType().getEnumCode();
        //  jsPayVatPaymentInfoReq.getTaxStationCountry().equals("英国") ? jsPayVatPaymentInfoReq.getBankCardNo():jsPayVatPaymentInfoReq.getIban();
        kycSunrateBeneficiaryReq.setBeneficiaryAcctNo(StringUtils.isEmpty(jsPayVatPaymentInfoReq.getIban()) ? jsPayVatPaymentInfoReq.getBankCardNo():jsPayVatPaymentInfoReq.getIban());
        kycSunrateBeneficiaryReq.setBeneficiaryAddr("VAT缴税受益人地址");
        kycSunrateBeneficiaryReq.setBeneficiaryType(BeneficiaryTypeEnum.VAT_PAYMENT);
        kycSunrateBeneficiaryReq.setBeneficiaryName(jsPayVatPaymentInfoReq.getCusName());
        kycSunrateBeneficiaryReq.setBrowserIP(jsPayVatPaymentInfoReq.getBrowserIP());
        kycSunrateBeneficiaryReq.setCountryCode(jsPayVatPaymentInfoReq.getTaxStationCountry());
        kycSunrateBeneficiaryReq.setCur(jsPayVatPaymentInfoReq.getVatPayCur());
        kycSunrateBeneficiaryReq.setIban(jsPayVatPaymentInfoReq.getIban());
        kycSunrateBeneficiaryReq.setRouteType(StringUtils.isEmpty(jsPayVatPaymentInfoReq.getIban()) ? "3":"2");
        kycSunrateBeneficiaryReq.setSwiftcode(jsPayVatPaymentInfoReq.getBankBic());
        kycSunrateBeneficiaryReq.setRemark("VAT缴税");
        log.info("添加受益人，调用寻汇接口start:");
        ResponseMessage responseMessage = apiSunrateBeneficiaryService.beneficiaryCreate(kycSunrateBeneficiaryReq,kycNaturalVO);
        return responseMessage;
    }

    public ResponseMessage addVatPayTradeForNoPass(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq){
        log.info("保存vat缴税记录，受益人审核未通过的 start:");
        List<JsPayVatSubAcctInfoVO> subAcctNoList = jsPayVatPaymentInfoReq.getSubAcctNoInfoList();
        for(JsPayVatSubAcctInfoVO subAcctNoVO : subAcctNoList){
            jsPayVatPaymentInfoReq.setStoreId(subAcctNoVO.getStoreId());
            jsPayVatPaymentInfoReq.setSubAcctNo(subAcctNoVO.getSubAcctNo());
            jsPayVatPaymentInfoReq.setVatPayAmt(subAcctNoVO.getPayAmt());
            jsPayVatPaymentInfoReq.setVatPayCur(subAcctNoVO.getPayCur());
            jsPayVatPaymentInfoReq.setStatus(StatusEnum.AUDITING.queryEnumCode());
            jsPayVatPaymentInfoReq.setId(IdUtil.simpleUUID());
            ResponseMessage responseMessage = apiJsPayVatPaymentInfoService.addPayVatPaymentInfo(jsPayVatPaymentInfoReq);
            if(!responseMessage.isSuccess()){
                return responseMessage;
            }
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage queryVatList() {

        return apiJsPayVatPaymentInfoService.queryVatList("");
    }

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ChinaPNRTransactionDetailsService chinaPNRTransactionDetailsService;
    @Override
    public ResponseMessage testVatChinaPNRTransaction() {
        ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq = new ChinaPNRTransactionDetailsReq();
        chinaPNRTransactionDetailsReq.setCurrencyCode("USD");
        chinaPNRTransactionDetailsReq.setKycNaturalId("ed1a79a3d200496f93fae409f56c8414");
        chinaPNRTransactionDetailsReq.setTargetAmount(new BigDecimal(800));
        chinaPNRTransactionDetailsReq.setAmazonEndpointEnum(AmazonEndpointEnum.US);
        chinaPNRTransactionDetailsReq.setExchangeRate(new BigDecimal(6));
        chinaPNRTransactionDetailsReq.setBatchNo("");
        return chinaPNRTransactionDetailsService.saveChinaPNRTransactionDetail(chinaPNRTransactionDetailsReq);
    }
    @Override
    public ResponseMessage submitTransactionDetails(String batchNo) {
        ChinaPNRTransactionReq chinaPNRTransactionReq = new ChinaPNRTransactionReq();
        chinaPNRTransactionReq.setCurrencyCode("USD");
        chinaPNRTransactionReq.setKycNaturalId("ed1a79a3d200496f93fae409f56c8414");
        chinaPNRTransactionReq.setExchangeRate(new BigDecimal(6));
        chinaPNRTransactionReq.setBatchNo(batchNo);
        chinaPNRTransactionReq.setTotalAmount(new BigDecimal(800));
        ResponseMessage responseMessage = null;
        try{
            responseMessage = chinaPNRTransactionDetailsService.submitTransactionDetails();
        }catch (Exception e ){
            log.error("submitTransactionDetails error");
        }
        return responseMessage;
    }

    @Override
    public ResponseMessage getSmsCode(String type, ValidateCodeReq validateCodeReq, HttpServletResponse response) throws Exception {
        String redisKey = "";
        int errorCountInteger = 0;
        log.info("{}发送验证码信息：{}",type,validateCodeReq);
        if(ValidateCodeType.SMS.toString().toLowerCase().equals(type)){
            if(org.apache.commons.lang3.StringUtils.isBlank(validateCodeReq.getPhoneNo()) || "null".equals(validateCodeReq.getPhoneNo())){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "-手机号不能为空");
            }
            if (!Validator.isMactchRegex(RegexConstant.PHONE_REGEX, validateCodeReq.getPhoneNo())) {
                log.info("手机号格式错误：{}",validateCodeReq.getPhoneNo());
                return ResultUtil.error(ResultEnum.PHONE_REGEX_ERROR);
            }
            redisKey = Constant.REDIS_JS_USER_SMS + validateCodeReq.getPhoneNo();
            String errorCountString = redisUtil.get(redisKey);
            errorCountInteger = org.apache.commons.lang3.StringUtils.isBlank(errorCountString) ? 0 : Integer.valueOf(errorCountString);
            if(errorCountInteger >= maxCount){
                //如果当前手机号发送超过最大次数且最大次数为取消时，提示信息
                return ResultUtil.error(ResultEnum.SEND_VALIDATE_CODE_ERROR.getCode(), ResultEnum.SEND_VALIDATE_CODE_ERROR.getMsg() + ", 已超过限制次数，请于24小时后重试.");
            }
        }
        Optional<ValidateCodeVO> validateCodeVO = validateCodeProcessorHolder.findValidateCodeProcessor(type).create(validateCodeReq, response);
        if (validateCodeVO.isPresent()) {
            if(ValidateCodeType.SMS.toString().toLowerCase().equals(type)){
                errorCountInteger = errorCountInteger + 1;
                redisUtil.setex(redisKey,Constant.LOGIN_TIMEOUT * 24,String.valueOf(errorCountInteger));
            }
            return ResultUtil.success(validateCodeVO.get(), ResultEnum.SEND_VALIDATE_CODE_SUCCESS);
        }
        return ResultUtil.error(ResultEnum.SEND_VALIDATE_CODE_ERROR);
    }

    /**
     *  用户vat缴税关系维护
     * @param jsPayVatPaymentInfoReq
     * @return
     */
    private ResponseMessage addPayUserStationInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq){
        log.info("用户vat缴税机构关系维护start:"+jsPayVatPaymentInfoReq.getTaxStationId());
        JsPayUserStationInfoVO jsPayUserStationInfoVO = new JsPayUserStationInfoVO();
        jsPayUserStationInfoVO.setCertificationName(jsPayVatPaymentInfoReq.getCreateName());
        jsPayUserStationInfoVO.setBeneficiaryId(jsPayVatPaymentInfoReq.getBeneficiaryId());
        jsPayUserStationInfoVO.setCreateId(jsPayVatPaymentInfoReq.getCreateId());
        jsPayUserStationInfoVO.setKycNaturalId(jsPayVatPaymentInfoReq.getKycNaturalId());
        jsPayUserStationInfoVO.setTaxStationId(jsPayVatPaymentInfoReq.getTaxStationId());
        return apiJsPayUserStationInfoService.addPayUserStationInfo(jsPayUserStationInfoVO);
    }


    private ResponseMessage insertVatStationInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq){
        jsPayVatPaymentInfoReq.setTaxStationId(IdUtil.simpleUUID());
        return apiJsPayStationOrganInfoService.insertVatStationInfo(jsPayVatPaymentInfoReq);
    }

    private ValidateCodeReq regiserReqConvertToValidateCodeReq(KycBankReq kycBankReq){
        ValidateCodeReq validateCodeReq = new ValidateCodeReq();
        validateCodeReq.setMarkStr(kycBankReq.getMarkStr());
        validateCodeReq.setPhoneNo(kycBankReq.getPhone());
        validateCodeReq.setSmsCode(kycBankReq.getSmsCode());
        return validateCodeReq;
    }
}
