package com.js.web.service;

import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

public interface EnterpriseInfoService {

    /**
     * 获取企业信息指标
     */
    ResponseMessage getEnterpriseInfo(String kycNaturalId);

    /**
     * 获取企业股东 >= 25% 人员信息
     */
    ResponseMessage getEnterprise25Partners(KycNaturalVO kycNaturalVO,String kycCertiId);

    /**
     * 穿透获取企业股东 >= 25% 人员信息
     */
    ResponseMessage getEnterprisePartners2(KycNaturalVO kycNaturalVO);

    /**
     * 校验公司名称与企业信用代码是否一致
     */
    ResponseMessage checkEnterpriseAndCreditCode(String kycNaturalId, String enterpriseName, String creditCode);

    /**
     * 判断企业信息是否发生过异常
     */
    ResponseMessage getHasException(String kycNaturalId, String enterpriseName);
}
