package com.js.web.controller.vat;

import com.js.common.constant.Constant;
import com.js.common.enums.RegisterType;
import com.js.common.enums.VatPayStationTypeEnum;
import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.req.KycShowStoreReq;
import com.js.common.model.req.ValidateCodeReq;
import com.js.common.model.vo.JsPayVatPaymentInfoVO;
import com.js.common.model.vo.JsPayVatSubAcctInfoVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycXGantiMoneyServiceVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.TestJsPayInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import com.js.web.service.JsPayVatPaymentInfoService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;


//  数据接口测试 Controller
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
@Slf4j
public class TestJsPayInfoController {
    @Autowired
    private TestJsPayInfoService testJsPayInfoService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;


    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/testJsPayInfoController/saveChinaPNRTransactionDetailTest")
    public ResponseMessage estVatChinaPNRTransaction() throws ParseException {
        ResponseMessage status = testJsPayInfoService.testVatChinaPNRTransaction();

        return status;
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/testJsPayInfoController/submitTransactionDetails")
    public ResponseMessage submitTransactionDetails(String batchNo){
        ResponseMessage status = testJsPayInfoService.submitTransactionDetails(batchNo);
        return status;
    }
}
