package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycHolderService;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 持有人相关前后端交互controller
 * @Date 2019/5/23
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE},
        consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsKycHolderController {
    @Autowired
    private JsKycHolderService jsKycHolderService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 持有人列表
     * @Author liuh
     * @Date 2019/5/23
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/kycHolder/holderList")
    public ResponseMessage holderList(@RequestParam(value = "holderName" ,required = false) String holderName,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycHolderService.kycHolderList(holderName,optionalKycNaturalVO.get());
    }

    /**
     * 添加持有人-个人
     * @Author liuh
     * @Date 2019/5/24
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/holder/addPersonal")
    public ResponseMessage holderPersonalAdd(@Valid @RequestBody KycHolderPersonalReq kycHolderPersonalReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        ResponseMessage responseMessage = jsKycHolderService.holderPersonalAdd(kycHolderPersonalReq,optionalKycNaturalVO.get());
        return responseMessage;
    }

    /**
     * 添加持有人-企业
     * @Author liuh
     * @Date 2019/5/24
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/holder/addCompany")
    public ResponseMessage holderCompanyAdd(@RequestBody KycHolderCompanyReq kycHolderCompanyReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycHolderService.holderCompanyAdd(kycHolderCompanyReq,optionalKycNaturalVO.get());
    }
}
