package com.js.web.validate.code.email;

import com.js.common.model.req.ValidateCodeReq;
import com.js.common.model.vo.ValidateCodeVO;
import com.js.web.validate.code.ValidateCode;
import com.js.web.validate.code.impl.AbstractValidateCodeProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

/**
 * 邮箱验证码发送
 */
@Component("emailValidateCodeProcessor")
public class EmailCodeProcessor extends AbstractValidateCodeProcessor<ValidateCode> {

    /**
     * 邮箱验证码发送器
     */
    @Autowired
    private EmailCodeSender emailCodeSender;

    @Override
    protected Optional<ValidateCodeVO> send(ValidateCodeReq validateCodeReq, ValidateCode validateCode, HttpServletResponse response){
        emailCodeSender.send(validateCodeReq, validateCode.getCode());
        ValidateCodeVO validateCodeVO = new ValidateCodeVO();
        validateCodeVO.setMarkStr(validateCode.getMarkStr());
        return Optional.of(validateCodeVO);
    }
}
