package com.js.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiKycCertiContactsService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiFileType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycCertiContactsReq;
import com.js.common.model.vo.KycCertiContactsVO;
import com.js.common.model.vo.KycCertiLinkFileVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.KycCertiContactsService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Description: 安全设置接口实现
 * @Author: liuh
 * @Create: 2019-07-8
 **/
@Slf4j
@Service
public class KycCertiContactsServiceImpl implements KycCertiContactsService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 30000,
            retries = 0
    )
    ApiKycCertiContactsService apiKycCertiContactsService;

    @Override
    public ResponseMessage saveKycCertiContacts(KycCertiContactsReq kycCertiContactsReq,KycNaturalVO kycNaturalVO) {
        if(CertiFileType.ID_CARD.equals(kycCertiContactsReq.getIdType())) {
            boolean longFlag = kycCertiContactsReq.getLongFlag();
            if (!longFlag && (null == kycCertiContactsReq.getEffectiveEndTime()
                    || kycCertiContactsReq.getEffectiveEndTime().getTime() < kycCertiContactsReq.getEffectiveStartTime().getTime())) {
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(), ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
            }
            if (longFlag) {
                kycCertiContactsReq.setEffectiveEndTime(CommonConstant.longFormatDate());
            }
        }
        ResponseMessage operKycContractsResponseMessage = null;
        if(StringUtils.isBlank(kycCertiContactsReq.getId())){
            log.info("{}保存联系人信息-开始",kycNaturalVO.getId());
            operKycContractsResponseMessage = apiKycCertiContactsService.saveKycCertiContacts(kycCertiContactsReq,kycNaturalVO);
            log.info("保存联系人信息-结束返回结果:{},描述信息:{}", operKycContractsResponseMessage.isSuccess(), operKycContractsResponseMessage.getMsg());
        }else{
            log.info("{}更新联系人信息-开始",kycNaturalVO.getId());
            operKycContractsResponseMessage = apiKycCertiContactsService.updateKycCertiContacts(kycCertiContactsReq, kycNaturalVO);
            log.info("更新联系人信息-结束返回结果:{},描述信息:{}", operKycContractsResponseMessage.isSuccess(), operKycContractsResponseMessage.getMsg());
        }
        return operKycContractsResponseMessage;
    }

    @Override
    public ResponseMessage getKycCertiContacts(String kycContractsId,String kycCertiId) {
        log.info("查询联系人信息入参：contractId:{},kycCertiId:{}",kycContractsId,kycCertiId);
        KycCertiContactsReq kycCertiContactsReq = new KycCertiContactsReq();
        kycCertiContactsReq.setId(kycContractsId);
        kycCertiContactsReq.setKycCertiId(kycCertiId);
        ResponseMessage kycCertiContacts = apiKycCertiContactsService.getKycCertiContacts(kycCertiContactsReq);
        List<KycCertiContactsVO> kycCertiContactsVOList = (List<KycCertiContactsVO>)kycCertiContacts.getData();
        if(CollectionUtils.isEmpty(kycCertiContactsVOList)){
            log.error("未查询到联系人信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        KycCertiContactsVO kycCertiContactsVO = kycCertiContactsVOList.get(0);
        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(kycCertiContactsVO));
        List<KycCertiLinkFileVO> kycCertiLinkFileVOList = kycCertiContactsVO.getKycCertiLinkFileReqList();
        if(CollectionUtils.isNotEmpty(kycCertiLinkFileVOList)) {
            kycCertiLinkFileVOList.stream().forEach(kycCertiLinkFileVO -> {
                jsonObject.put(kycCertiLinkFileVO.getFileType().name(), kycCertiLinkFileVO.getFileSavePath());
            });
        }
        return ResultUtil.success(jsonObject);
    }
}
