package com.js.web.service.impl;

import com.js.api.jsloan.service.ApiJsLoanBillFileService;
import com.js.common.constant.Constant;
import com.js.common.model.req.JsLoanBillFilePageReq;
import com.js.common.model.req.JsLoanBillFileReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsLoanBillFileService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

/**
 * @Author zhouyngsheng
 * @Description 贷款对账文件操作
 * @Date 2019/8/1
 **/
@Slf4j
@Service
public class JsLoanBillFileServiceImpl implements JsLoanBillFileService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    ApiJsLoanBillFileService apiJsLoanBillFileService;

    @Override
    public ResponseMessage applyQuery(JsLoanBillFilePageReq jsLoanBillFilePageReq) {
        return apiJsLoanBillFileService.applyQuery(jsLoanBillFilePageReq);
    }


    @Override
    public ResponseMessage applyOperation(JsLoanBillFileReq jsLoanBillFileReq) {
        return apiJsLoanBillFileService.applyOperation(jsLoanBillFileReq);
    }

    @Override
    public ResponseMessage download(String kycNaturalId,String loanBillNo) {
        return apiJsLoanBillFileService.download(kycNaturalId,loanBillNo);
    }
}
