package com.js.web.service.impl;

import com.js.api.jsloan.service.ApiJsLoanApplicationService;
import com.js.api.jsloan.service.fadada.ApiFadadaService;
import com.js.api.sync.service.AmazonDataSyncService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.*;
import com.js.common.model.resp.FadadaContractVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.FadadaService;
import com.js.web.service.JsLoanApplicationService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Description: 贷款申请
 * @Author: zhouyongsheng
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class JsLoanApplicationServiceImpl implements JsLoanApplicationService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    ApiJsLoanApplicationService apiJsLoanApplicationService;

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    ApiFadadaService apiFadadaService;

    @Autowired
    FadadaService fadadaService;

    @Override
    public ResponseMessage loanApply(JsLoanApplyInfoReq req) {
        ResponseMessage responseMessage = apiJsLoanApplicationService.loanApply(req);
        return responseMessage;
    }

    @Override
    public ResponseMessage loanApplicationDetailed(String loanNo, String kycNaturalId) {
        return apiJsLoanApplicationService.loanApplicationDetailed(loanNo,kycNaturalId);
    }

    @Override
    public ResponseMessage queryLoan(LoanApplicationReq loanApplicationReq) {
        return apiJsLoanApplicationService.queryLoan(loanApplicationReq);
    }

    @Override
    public ResponseMessage loanDetailed(String loanNo,String kycNaturalId) {
        return apiJsLoanApplicationService.loanDetailed(loanNo,kycNaturalId);
    }

    /**
     * 签署支用合同查询
     * @param loanNo
     * @param kycNaturalId
     * @return
     */
    @Override
    public ResponseMessage loanContract(String loanNo, String kycNaturalId) {
        ResponseMessage message =  apiJsLoanApplicationService.loanContract(loanNo,kycNaturalId);
        if(!message.isSuccess()){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"签署支用合同查询失败");
        }
        Map<String,Object> resMap = (Map<String,Object>)message.getData();
        ResponseMessage messageFadada =  apiFadadaService.getSignStatus(loanNo);
        if(!messageFadada.isSuccess()){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"签署支用合同查询失败");
        }
        Map<String, Object> result = (Map<String, Object>)messageFadada.getData();
        resMap.put("total",result.get("total"));
        resMap.put("signed",result.get("signed"));
        resMap.put("status",result.get("status"));
        return ResultUtil.success(resMap,ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage queryContract(String loanNo,String kycNaturalId) {
        ResponseMessage jsLoanMessage = apiJsLoanApplicationService.queryContract(loanNo,kycNaturalId);
        if(!jsLoanMessage.isSuccess()){
             log.info("合同详情查询失败-未查询到借款信息... loanNo:{}",loanNo ) ;
             return ResultUtil.error(ResultEnum.ERROR.getCode(),"查询借款信息失败");
        }
        Map<String,Object> resMap = (Map<String,Object>)jsLoanMessage.getData();
        log.info("合同查询resMap结果：{}" ,resMap);

        ResponseMessage viewUrlMessage = fadadaService.getContractViewUrl(loanNo);
        if(!viewUrlMessage.isSuccess()){
            log.info("合同详情查询失败-查询合同异常... loanNo:{}",loanNo ) ;
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"同详情查询失败-查询合同异常");
        }
        List<FadadaContractVO> urlList = (List<FadadaContractVO>)viewUrlMessage.getData();
        resMap.put("urlList",urlList);
        return ResultUtil.success(resMap,ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage signContract(SignContractReq signContractReq,KycNaturalVO kycNaturalVO) {
        log.info("签署合同开始 loanNo:{},KycNaturalVo:{}",signContractReq.getLoanNo(),kycNaturalVO.getId());
        ResponseMessage responseMessage = apiJsLoanApplicationService.signContract(signContractReq,kycNaturalVO);
        log.info("签署合同组装PDF返回结果message:{} ",responseMessage.getMsg());
        if(!responseMessage.isSuccess()){
            return  ResultUtil.error(ResultEnum.ERROR.getCode(),responseMessage.getMsg());
        }
        Map<String,Object> fadadaMap = (Map<String,Object>)responseMessage.getData();
        FadadaUploadContractReq fadadaUploadContractReq = (FadadaUploadContractReq)fadadaMap.get("fadadaUploadContractReq");
        ResponseMessage uploadContrMessage = apiFadadaService.uploadContract2(fadadaUploadContractReq);
        log.info("法大大上传合同返回结果message:{} ",uploadContrMessage);
        if(!responseMessage.isSuccess()){
            return  ResultUtil.error(ResultEnum.ERROR.getCode(),"法大大上次合同失败:" + responseMessage.getMsg());
        }
        ResponseMessage signMessage = apiFadadaService.sign(fadadaMap.get("riskNo").toString(), signContractReq.getLoanNo());
        if(!signMessage.isSuccess()){
            apiFadadaService.deleteContract(signContractReq.getLoanNo());
            return  ResultUtil.error(ResultEnum.ERROR.getCode(),"法大大签署合同失败:" + signMessage.getMsg());
        }
        return apiFadadaService.getUnSignContractByLoanNo(signContractReq.getLoanNo());
    }

    @Override
    public ResponseMessage capitalDetailed(LoanCapitalReq loanCapitalReq) {
        return apiJsLoanApplicationService.capitalDetailed(loanCapitalReq);
    }

    @Override
    public ResponseMessage capitalDetailedDetails(String capitalNo, String accType) {
        return apiJsLoanApplicationService.capitalDetailedDetails(capitalNo,accType);
    }

    /**
     * 合同归档
     * @param loanNo
     * @param kycNaturalVO
     * @return
     */
    @Override
    public ResponseMessage signVerification(String loanNo, KycNaturalVO kycNaturalVO){
        //贷款编号验证
        if(StringUtils.isEmpty(loanNo)){
            log.info("贷款编号loanNo不能为空");
            return  ResultUtil.error(ResultEnum.ERROR.getCode(),"贷款编号loanNo不能为空");
        }
        //查询合同签署完毕
        ResponseMessage unSignContrMessage = apiFadadaService.getUnSignContractByLoanNo(loanNo);
        if(!unSignContrMessage.isSuccess()){
            log.info("查询未签署合同失败 loanNo:{}",loanNo);
            return  ResultUtil.error(ResultEnum.ERROR.getCode(),"查询未签署合同失败");
        }
        Map<String, Object> urlMap = (Map<String, Object>) unSignContrMessage.getData();
        //还有未签署完成的合同
        if (((List) urlMap.get("urls")).size() > 0) {
            log.info("查询到未签署完成的合同，请继续签署 urlMap:{},loanNO:{}", urlMap, loanNo);
            return unSignContrMessage;
        }
        //如果签署完毕则归档
        ResponseMessage archiveMessage = apiFadadaService.archiveContract2(kycNaturalVO.getId(),loanNo);
        if(!archiveMessage.isSuccess()){
            log.info("法大大签署合同归档失败 loanNo:{}",loanNo);
            return  ResultUtil.error(ResultEnum.ERROR.getCode(),"法大大签署合同归档失败");
        }
        //上次合同
        fadadaService.uploadContractToOSS(loanNo);
        //更新借款信息签署合同状态
        return apiJsLoanApplicationService.signVerification(loanNo,kycNaturalVO);
    }
}
