package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.*;
import com.js.api.sync.service.AmazonDataSyncService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.api.sync.service.CheckAuthTokenService;
import com.js.web.service.IMailService;
import com.js.web.service.JsKycStoreService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description: 申请虚拟账户-添加店铺服务实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class JsKycStoreServiceImpl implements JsKycStoreService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycStoreService apiKycStoreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycSunrateStoreService apiKycSunrateStoreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsPaySunrateBankService apiJsPaySunrateBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsKycChargeService apiJsKycChargeService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycBankService apiKycBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private CheckAuthTokenService checkAuthTokenService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private AmazonDataSyncService amazonDataSyncService;
    @Autowired
    IMailService iMailService;

    @Override
    public ResponseMessage addStore(KycStoreReq kycStoreReq, KycNaturalVO kycNaturalVO) {
        if(kycStoreReq.getStoreSituation() && (StringUtils.isBlank(kycStoreReq.getSellId()) || StringUtils.isBlank(kycStoreReq.getMwsAuthToken()))){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + ",已有店铺时,请填写卖家编号和token");
        }
        if(kycStoreReq.getStoreSituation() && StringUtils.isBlank(kycStoreReq.getStoreUrl())){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + ",已有店铺时,店铺链接不能为空");
        }
        log.info("当前实名状态:{}",kycNaturalVO.getCertificationStatus());
        if(!CertiStatusEnum.SUCCESS.equals(kycNaturalVO.getCertificationStatus())){
            return ResultUtil.error(ResultEnum.CERTI_WATRING.getCode(),ResultEnum.CERTI_WATRING.getMsg());
        }
        if(kycStoreReq.getStoreSituation()){
            // 调用未通过表示授权不成功，则返回错误信息
            KycStoreCheckTokenReq kycStoreCheckTokenReq = new KycStoreCheckTokenReq();
            kycStoreCheckTokenReq.setMwsAuthToken(kycStoreReq.getMwsAuthToken());
            kycStoreCheckTokenReq.setSellId(kycStoreReq.getSellId());
            kycStoreCheckTokenReq.setStoreTheSite(kycStoreReq.getStoreTheSite());
            ResponseMessage responseMessage = checkAuthTokenService.checkToken(kycStoreCheckTokenReq);
            if (!responseMessage.isSuccess()) {
                return responseMessage;
            }
        }
        ResponseMessage addStoreResponseMessage = apiKycStoreService.addStore(kycStoreReq, kycNaturalVO);
        if(!addStoreResponseMessage.isSuccess()){
            return addStoreResponseMessage;
        }
        String kycStoreId = addStoreResponseMessage.getData().toString();
        // 同步卖家店铺数据
        if (kycStoreReq.getStoreSituation()) {
            amazonDataSyncService.startSyncStoreData(kycStoreId);
        }
        log.info("请求寻汇公共方法添加店铺信息-开始");
        KycSunrateStoreReq kycSunrateStoreReq = ConvertToKycSunrateStoreReq(kycStoreReq,kycNaturalVO);
        kycSunrateStoreReq.setStoreTheSite(kycStoreReq.getStoreTheSite());
        ResponseMessage responseMessage = apiKycSunrateStoreService.sendSunrateStoreInfoToXh(kycStoreReq.getBrowserIP(), kycSunrateStoreReq);
        log.info("请求寻汇公共方法添加店铺信息-结束，请求结果：{}，返回信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
        if(!responseMessage.isSuccess()){
            KycStoreEditReq kycStoreEditReq = new KycStoreEditReq();
            kycStoreEditReq.setKycStoreId(kycStoreId);
            kycStoreEditReq.setProcessStatus(ProcessStatusEnum.TRADE_UNPROCESSED);
            apiKycStoreService.editStoreProcessStatus(kycStoreEditReq,kycNaturalVO);
            iMailService.sendRemindEmail("申请境外收款账户", "申请境外收款账户请求寻汇异常 :" + JSON.toJSONString(responseMessage), EmailRemindTypeEnum.WARN_EMAIL);
            return addStoreResponseMessage;
        }
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
        String subAcctNo = jsonObject.getString("subAcctNo");
        String storeName = jsonObject.getString("storeName");
        kycSunrateStoreReq.setKycStoreId(kycStoreId);
        kycSunrateStoreReq.setSubAcctNo(subAcctNo);
        kycSunrateStoreReq.setStoreName(storeName);
        kycSunrateStoreReq.setStoreTheSite(kycStoreReq.getStoreTheSite());
        log.info("保存请求寻汇添加店铺信息-开始");
        ResponseMessage responseMessage1 = apiKycSunrateStoreService.addSunrateStore(kycSunrateStoreReq, kycNaturalVO);
        log.info("保存请求寻汇添加店铺信息-结束，请求结果：{}，返回信息:{}",responseMessage1.isSuccess(),responseMessage1.getMsg());
        return addStoreResponseMessage;
    }

    private KycSunrateStoreReq ConvertToKycSunrateStoreReq(KycStoreReq kycStoreReq, KycNaturalVO kycNaturalVO){
        String orgCode = apiSunrateTradePriceService.findOrgCode(kycNaturalVO.getId(),kycNaturalVO.getRegisterType());
        KycSunrateStoreReq kycSunrateStoreReq = new KycSunrateStoreReq();
        kycSunrateStoreReq.setOrgCode(orgCode);
        kycSunrateStoreReq.setCurId(kycStoreReq.getStoreTheSite().getCurrency());
        kycSunrateStoreReq.setStoreName(kycStoreReq.getStoreName());
        if(kycStoreReq.getStoreSituation()) {
            kycSunrateStoreReq.setStoreUrl(kycStoreReq.getStoreUrl());
        }
        kycSunrateStoreReq.setStorePlateform(kycStoreReq.getStorePlateform().getCode());
        if(StringUtils.isNotBlank(kycStoreReq.getSellId())){
            kycSunrateStoreReq.setSellerId(kycStoreReq.getSellId());
        }
        return kycSunrateStoreReq;
    }

    @Override
    public ResponseMessage storeList(KycShowStoreReq kycShowStoreReq, KycNaturalVO kycNaturalVO) {
        return apiKycStoreService.storeList(kycShowStoreReq,kycNaturalVO);
    }

    @Override
    public ResponseMessage findApplyCountNum(String browserIP,KycNaturalVO kycNaturalVO) {
        return apiKycStoreService.findApplyCountNum(browserIP,kycNaturalVO);
    }

    @Override
    public ResponseMessage findStoreDetailInfo(String kycStoreId, KycNaturalVO kycNaturalVO) {
        log.info("查询店铺信息:{}",kycStoreId);
        KycStoreVO kycStoreVO = apiKycStoreService.findKycStoreByPrimaryKey(kycStoreId, kycNaturalVO);
        if(null == kycStoreVO){
            log.error("未查询到店铺信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        log.info("查询到店铺信息:{}",JSON.toJSONString(kycStoreVO));
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("storeInfo",kycStoreVO);
        KycSunrateStoreVO kycSunrateStoreVO = apiKycSunrateStoreService.findSunrateStoreInfo(kycStoreVO.getId(),"", kycNaturalVO.getId());
        if(null == kycSunrateStoreVO){
            log.info("未查询到-寻汇-店铺信息");
            return ResultUtil.success(resultMap);
        }
        JsPaySunrateBankReq jsPaySunrateBankReq = new JsPaySunrateBankReq();
        jsPaySunrateBankReq.setOrgCode(kycSunrateStoreVO.getOrgCode());
        jsPaySunrateBankReq.setSubAcctNo(kycSunrateStoreVO.getSubAcctNo());
        JsPaySunrateBankVO jsPaySunrateBankVO = apiJsPaySunrateBankService.findSunrateBankInfo(jsPaySunrateBankReq, kycNaturalVO);
        if(null == jsPaySunrateBankVO){
            log.info("未查询到虚拟账户信息");
            return ResultUtil.success(resultMap);
        }
        SiteEnum siteEnum = SiteEnum.getByCurrency(jsPaySunrateBankVO.getCurId());
        jsPaySunrateBankVO.setCurIdSymbol(null == siteEnum ? "" : siteEnum.getCurrencySymbol());
        resultMap.put("accountInfo",jsPaySunrateBankVO);
        return ResultUtil.success(resultMap);
    }

    @Override
    public ResponseMessage editStore(KycStoreEditReq kycStoreEditReq, KycNaturalVO kycNaturalVO) {
        log.info("当前实名状态:{}",kycNaturalVO.getCertificationStatus());
        if(CertiStatusEnum.FAILURE.equals(kycNaturalVO.getCertificationStatus())){
            return ResultUtil.error(ResultEnum.CERTI_FAILURE.getCode(),ResultEnum.CERTI_FAILURE.getMsg());
        }else if(CertiStatusEnum.NO_SUBMIT.equals(kycNaturalVO.getCertificationStatus())
                || CertiStatusEnum.SUBMIT_FAILURE.equals(kycNaturalVO.getCertificationStatus())){
            return ResultUtil.error(ResultEnum.CERTI_WATRING);
        }
        KycSunrateStoreVO sunrateStoreInfoVO = apiKycSunrateStoreService.findSunrateStoreInfo(kycStoreEditReq.getKycStoreId(), "", kycNaturalVO.getId());
        if(null != sunrateStoreInfoVO.getAuditStatus() && 1 == sunrateStoreInfoVO.getAuditStatus()){
            log.error("店铺审核已通过不可以编辑");
            return ResultUtil.error(ResultEnum.SUNRATE_STORE_PASSED);
        }
        // 调用未通过标识授权不成功，则返回错误信息
        KycStoreCheckTokenReq kycStoreCheckTokenReq = new KycStoreCheckTokenReq();
        kycStoreCheckTokenReq.setStoreTheSite(kycStoreEditReq.getStoreTheSite());
        kycStoreCheckTokenReq.setSellId(kycStoreEditReq.getSellId());
        kycStoreCheckTokenReq.setMwsAuthToken(kycStoreEditReq.getMwsAuthToken());
        ResponseMessage responseMessage = checkAuthTokenService.checkToken(kycStoreCheckTokenReq);
        if (!responseMessage.isSuccess()) {
            return responseMessage;
        }
        ResponseMessage result = apiKycStoreService.editStore(kycStoreEditReq, kycNaturalVO,sunrateStoreInfoVO);
        if (result.isSuccess()) {
            // 开始同步卖家店铺数据
            amazonDataSyncService.startSyncStoreData(kycStoreEditReq.getKycStoreId());
        }
        return result;
    }

    @Override
    public ResponseMessage findCanWithdrawStoreList(SiteEnum siteEnum, KycNaturalVO kycNaturalVO) {
        ResponseMessage responseMessage = apiJsPaySunrateBankService.selCanWithdrawAcctList(siteEnum,kycNaturalVO);
        return responseMessage;
    }

    @Override
    public ResponseMessage initWithdrawInfo(SiteEnum storeTheSite,KycNaturalVO kycNaturalVO) {
        JSONObject jsonObject = new JSONObject();
        JsKycChargeReq jsKycChargeReq = new JsKycChargeReq();
        jsKycChargeReq.setKycNaturalId(kycNaturalVO.getId());
        jsKycChargeReq.setChargeType("SERVICE_CHARGE");
        jsKycChargeReq.setStoreTheSite(storeTheSite);
        JsKycChargeVO jsKycChargeVO = apiJsKycChargeService.findKycChargeInfo(jsKycChargeReq);
        DecimalFormat df = new DecimalFormat("0.00%");
        //显示手续费
        jsonObject.put("serviceCharge",null == jsKycChargeVO ? df.format(storeTheSite.getJsTradeServiceChargeValue()) : df.format(jsKycChargeVO.getChargeScale()));
        KycBankCardReq kycBankCardReq = new KycBankCardReq();
        kycBankCardReq.setKycNaturalId(kycNaturalVO.getId());
        ResponseMessage bankListResponse = apiKycBankService.getKycBankList(kycBankCardReq);
        Set<String> set = new HashSet<>();
        if(bankListResponse.isSuccess()){
            JSONArray jsonArray = JSONArray.parseArray(JSON.toJSONString(bankListResponse.getData()));
            for(int i = 0 ; i < jsonArray.size(); i ++){
                JSONObject jsonObject1 = jsonArray.getJSONObject(i);
                set.add(jsonObject1.getString("currencyCode"));
            }
        }
        List<Map<String,Object>> currencyList = new ArrayList<>();//银行卡可用币种集合
        for(String currencyCode : set){
            if(CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                Map<String,Object> currencyMap = new HashMap<>();
                currencyMap.put("currencyKyc",CommonConstant.TRADE_CURRENCY_CNY);
                currencyMap.put("currency",CommonConstant.TRADE_CURRENCY_CNY + "/人民币");
                currencyList.add(currencyMap);
            }else{
                SiteEnum siteEnum = SiteEnum.getByCurrency(currencyCode);
                if(null == siteEnum){
                    Map<String,Object> currencyMap = new HashMap<>();
                    currencyMap.put("currencyKyc","");
                    currencyMap.put("currency",currencyCode);
                    currencyList.add(currencyMap);
                }else{
                    Map<String,Object> currencyMap = new HashMap<>();
                    currencyMap.put("currencyKyc",siteEnum.getCurrency());
                    currencyMap.put("currency",siteEnum.getCurrency() + "/" + siteEnum.getHyDesc());
                    currencyList.add(currencyMap);
                }
            }
        }
        jsonObject.put("currencyList",currencyList);
        return ResultUtil.success(jsonObject);
    }

    @Override
    public ResponseMessage checkStoreToken(KycStoreCheckTokenReq kycStoreCheckTokenReq) {
        return checkAuthTokenService.checkToken(kycStoreCheckTokenReq);
    }

    @Override
    public ResponseMessage showWithdrawCharge(KycNaturalVO kycNaturalVO) {
        return apiKycStoreService.showWithdrawCharge(kycNaturalVO);
    }

    @Override
    public ResponseMessage showTradeInit(TradeTypeEnum tradeType,KycNaturalVO kycNaturalVO) {
        JSONObject jsonObject = new JSONObject();
        if(TradeTypeEnum.TRADE_IN.equals(tradeType)){
            ResponseMessage applySite = apiKycStoreService.findApplySite(kycNaturalVO);
            jsonObject.put("siteList",applySite.getData());
        }else if(TradeTypeEnum.TRADE_WITHDRAW.equals(tradeType)){
            List<Map<String,Object>> processStatusMapList = new ArrayList<>();
            Map<String,Object> map = new HashMap<>();
            map.put("siteKey",ProcessStatusEnum.TRADE_PROCESSEDING.name());
            map.put("siteDesc","提现中");
            processStatusMapList.add(map);
            map = new HashMap<>();
            map.put("siteKey",ProcessStatusEnum.TRADE_PROCESSED.name());
            map.put("siteDesc","提现成功");
            processStatusMapList.add(map);
            map = new HashMap<>();
            map.put("siteKey",ProcessStatusEnum.TRADE_PROCESSED_FAILURE.name());
            map.put("siteDesc","提现失败");
            processStatusMapList.add(map);
            jsonObject.put("processStatusList",processStatusMapList);
            KycBankCardReq kycBankCardReq = new KycBankCardReq();
            kycBankCardReq.setKycNaturalId(kycNaturalVO.getId());
            ResponseMessage bankListResponse = apiKycBankService.getKycBankList(kycBankCardReq);
            jsonObject.put("kycBankList",bankListResponse.getData());
        }else if(TradeTypeEnum.TRADE_REPAYMENT.equals(tradeType)){
            List<Map<String,Object>> processStatusMapList = new ArrayList<>();
            Map<String,Object> map = new HashMap<>();
            map.put("repaymentStatusKey",ProcessStatusEnum.TRADE_PROCESSEDING.name());
            map.put("repaymentStatusDesc","正在还款");
            processStatusMapList.add(map);
            map = new HashMap<>();
            map.put("repaymentStatusKey",ProcessStatusEnum.TRADE_PROCESSED.name());
            map.put("repaymentStatusDesc","还款成功");
            processStatusMapList.add(map);
            map = new HashMap<>();
            map.put("repaymentStatusKey",ProcessStatusEnum.TRADE_PROCESSED_FAILURE.name());
            map.put("repaymentStatusDesc","还款失败");
            processStatusMapList.add(map);
            jsonObject.put("processStatusList",processStatusMapList);

            List<Map<String,Object>> repaymentTypeMapList = new ArrayList<>();
            for(TradeSubTypeEnum repaymentType : TradeSubTypeEnum.values()){
                if(!repaymentType.name().startsWith("REPAYMENT_")){
                    continue;
                }
                Map<String,Object> repaymentTypeMap = new HashMap<>();
                repaymentTypeMap.put("repaymentTypeKey",repaymentType.name());
                repaymentTypeMap.put("repaymentTypeDesc",repaymentType.getDesc());
                repaymentTypeMapList.add(repaymentTypeMap);
            }
            jsonObject.put("repaymentTypeList",repaymentTypeMapList);

            List<Map<String,Object>> currencyMapList = new ArrayList<>();
            for(SiteEnum siteEnum : SiteEnum.values()){
                Map<String,Object> currencyMap = new HashMap<>();
                currencyMap.put("currencyKey",siteEnum.getCurrency());
                currencyMap.put("currencyDesc",siteEnum.getHyDesc());
                currencyMapList.add(currencyMap);
            }
            currencyMapList = currencyMapList.stream().distinct().collect(Collectors.toList());
            jsonObject.put("currencyList",currencyMapList);
            ResponseMessage sunrateBankInfoList = apiJsPaySunrateBankService.findSunrateBankInfoList(kycNaturalVO);
            jsonObject.put("sunrateBankList",sunrateBankInfoList);
        }
        return ResultUtil.success(jsonObject);
    }

    @Override
    public ResponseMessage showStoreListByCondition(StorePlateformEnum storePlateform, SiteEnum storeTheSite, KycNaturalVO kycNaturalVO) {
        KycStoreReq kycStoreReq = new KycStoreReq();
        kycStoreReq.setStorePlateform(storePlateform);
        kycStoreReq.setStoreTheSite(storeTheSite);
        ResponseMessage responseMessage = apiKycStoreService.storeListNoPage(kycStoreReq,kycNaturalVO);
        return responseMessage;
    }
}
