package com.js.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiKycCertiMainLandPersonalService;
import com.js.api.jspay.service.ApiKycSunrateService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.EmailRemindTypeEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.CertiMainLandPersonalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.IdCardUtils;
import com.js.common.util.ResultUtil;
import com.js.web.mq.RabbitMQSender;
import com.js.web.service.IMailService;
import com.js.web.service.JsKycCertiMainLandPersonalService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @Description: 大陆个人操作服务实现
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Slf4j
@Service
public class JsKycCertiMainLandPersonalServiceImpl implements JsKycCertiMainLandPersonalService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycCertiMainLandPersonalService  apiKycCertiMainLandPersonalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycSunrateService apiKycSunrateService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiSunrateRegisterService apiSunrateRegisterService;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;
    @Autowired
    RabbitMQSender rabbitMQSender;
    @Autowired
    IMailService iMailService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;

    @Value("${jsweb.validate.idcard.needmatch}")
    private Boolean needmatch;

    @Override
    public ResponseMessage certiMainLandPersonalAdd(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO) {
        log.info("大陆个人实名入参：{}", certiMainLandPersonalReq);
        if(!CertiStatusEnum.NO_SUBMIT.equals(kycNaturalVO.getCertificationStatus()) && !CertiStatusEnum.FIRST_TRIAL_FAILURE.equals(kycNaturalVO.getCertificationStatus())){
            log.error("{},{}用户已提交实名信息:{}",kycNaturalVO.getId(),kycNaturalVO.getRegisterType(),kycNaturalVO.getCertificationStatus());
            return ResultUtil.error(ResultEnum.CERTI_ALREADY_SUBMIT);
        }
        if(StringUtils.isNotBlank(certiMainLandPersonalReq.getId()) && kycNaturalVO.getId().equals(certiMainLandPersonalReq.getId())){
            log.error("当前登录用户：{}，需要编辑用户：{}，不符合",kycNaturalVO.getId(),certiMainLandPersonalReq.getId());
            return ResultUtil.error(ResultEnum.ERROR);
        }
        if(!kycNaturalVO.getEmailActiveFlag()){
            log.error("邮箱未激活,不可以提交实名信息");
            return ResultUtil.error(ResultEnum.EMAIL_NOT_ACTIVE);
        }
        if(StringUtils.isBlank(certiMainLandPersonalReq.getId())) {
            boolean existsFlag = apiKycCertiMainLandPersonalService.verifyCertiMainLandPersonExists(certiMainLandPersonalReq.getIdNo());
            if (existsFlag) {
                return ResultUtil.error(ResultEnum.MESSAGE_EXIST.getCode(), ResultEnum.MESSAGE_EXIST.getMsg());
            }
        }
        boolean longFlag = certiMainLandPersonalReq.getLongFlag();
        if(!longFlag && (null == certiMainLandPersonalReq.getEffectiveEndTime()
            || certiMainLandPersonalReq.getEffectiveEndTime().getTime() < certiMainLandPersonalReq.getEffectiveStartTime().getTime())){
           return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(), ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
        }
        if(longFlag){
            certiMainLandPersonalReq.setEffectiveEndTime(CommonConstant.longFormatDate());
        }
        try {
           if(needmatch){
               Boolean match = IdCardUtils.isMatch(certiMainLandPersonalReq.getCusName(), certiMainLandPersonalReq.getIdNo());
               log.error("姓名：{}，身份证号：{}，认证结果:{}", certiMainLandPersonalReq.getCusName(), certiMainLandPersonalReq.getIdNo(), match);
               if (!match) {
                   return ResultUtil.error(ResultEnum.ERROR.getCode(), "姓名与身份证不符,请核实");
               }
           }
            ResponseMessage operPersonResponseMessage = null;
            if(StringUtils.isBlank(certiMainLandPersonalReq.getId())){
                log.info("保存大陆个人-实名信息-开始");
                operPersonResponseMessage = apiKycCertiMainLandPersonalService.certiMainLandPersonalAdd(certiMainLandPersonalReq, kycNaturalVO);
                log.info("保存大陆个人-实名信息-结束返回结果:{},描述信息:{}", operPersonResponseMessage.isSuccess(), operPersonResponseMessage.getMsg());
            }else{
                log.info("更新大陆个人-实名信息-开始");
                operPersonResponseMessage = apiKycCertiMainLandPersonalService.certiMainLandPersonalUpdate(certiMainLandPersonalReq, kycNaturalVO);
                log.info("更新大陆个人-实名信息-结束返回结果:{},描述信息:{}", operPersonResponseMessage.isSuccess(), operPersonResponseMessage.getMsg());
            }
            if(operPersonResponseMessage.isSuccess()){
                String phoneNo = kycNaturalVO.getPhoneNo();
                String phoneStr = phoneNo.substring(3,7);
                String str = phoneNo.replace(phoneStr,"****");
                String emailContent = "亲，有新用户注册啦，请尽快审核。用户名：" + certiMainLandPersonalReq.getCusName() + ",手机号：" + str;
                iMailService.sendRemindEmail("用户审核提醒",emailContent , EmailRemindTypeEnum.REMIND_EMAIL);
            }
            return operPersonResponseMessage;
        }catch (Exception ex){
            log.error("大陆个人实名认证处理异常", ex);
            iMailService.sendRemindEmail("大陆个人实名认证处理异常", "大陆个人实名认证处理异常:" + JSON.toJSONString(ex), EmailRemindTypeEnum.WARN_EMAIL);
            return ResultUtil.error(ResultEnum.ERROR);
        }
    }

    @Override
    public ResponseMessage getCertiInfoDetail(KycNaturalVO kycNaturalVO) {
        if(!CertiStatusEnum.FIRST_TRIAL_FAILURE.equals(kycNaturalVO.getCertificationStatus()) && !CertiStatusEnum.CONTACTS_AUDIT_FAILURE.equals(kycNaturalVO.getCertificationStatus())){
            log.error("查询编辑信息不在可以编辑状态：{}",kycNaturalVO.getCertificationStatus());
            return ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        JSONObject certiInfo = apiSunrateTradePriceService.findCertiInfo(kycNaturalVO.getId(), kycNaturalVO.getRegisterType());
        certiInfo.put("jsRemark",kycNaturalVO.getJsRemark());
        return ResultUtil.success(certiInfo);
    }
}
