package com.js.web.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.*;
import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycCertiLinkFileVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycBankService;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import com.js.web.validate.code.ValidateCodeException;
import com.js.web.validate.code.ValidateCodeProcessorHolder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * @Description: kyc_bank交互操作
 * @Author: liuh
 * @Create: 2019-06-22
 **/
@Slf4j
@Service
public class
JsKycBankServiceImpl implements JsKycBankService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycBankService apiKycBankService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Autowired
    private ValidateCodeProcessorHolder validateCodeProcessorHolder;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsBankService apiJsBankService;

    @Override
    public ResponseMessage bankList(KycBankCardReq kycBankCardReq,KycNaturalVO kycNaturalVO) {
        if(null == kycBankCardReq.getBindingType()){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "-请填写绑卡渠道");
        }
        kycBankCardReq.setKycNaturalId(kycNaturalVO.getId());
        return apiKycBankService.getKycBankList(kycBankCardReq);
    }

    @Override
    public ResponseMessage initAddBank(KycNaturalVO kycNaturalVO) {
        List<Map<String,Object>> bankAreaList = new ArrayList<>();//銀行所在地區集合
        Map<String,Object> bankArea;
        List<Map<String,Object>> currencyWbList = new ArrayList<>();//外幣集合
        Map<String,Object> currencyWbMap;
        List<Map<String,Object>> currencyCNYList = new ArrayList<>();//人民幣集合
        Map<String,Object> currencyCNYMap = new HashMap<>();
        List<Map<String,Object>> currencyAcctPersonalList = new ArrayList<>();//個人戶名集合
        Map<String, Object> acctPersonalNameMap;
        List<Map<String,Object>> currencyAcctCompanyList = new ArrayList<>();//企業戶名集合
        Map<String, Object> acctCompanyNameMap;
        List<Map<String,Object>> companyAcctTypeList = new ArrayList<>();//对公户时，对公，对私集合
        Map<String, Object> companyAcctTypeMap;
        //初始化对公户账户类型-开始
        for(BankAcctTypeEnum bankAcctTypeEnum : BankAcctTypeEnum.values()){
            companyAcctTypeMap = new HashMap<>();
            companyAcctTypeMap.put("companyAcctType", bankAcctTypeEnum.name());
            companyAcctTypeMap.put("companyAcctDesc", bankAcctTypeEnum.getDesc());
            companyAcctTypeList.add(companyAcctTypeMap);
        }
        //初始化对公户账户类型-结束

        //初始化银行所在地区-开始
        if( RegisterType.MAINLAND_PERSONAL.equals(kycNaturalVO.getRegisterType())
            || RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType())
            || RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType())){
            //银行所在地区-大陆
            bankArea = new HashMap<>();
            bankArea.put("bankAreaType",BankAreaType.MAIN_LAND.name());
            bankArea.put("bankAreaDesc", BankAreaType.MAIN_LAND.getDesc());
            bankAreaList.add(bankArea);
        }
        if( RegisterType.HK_PERSONAL.equals(kycNaturalVO.getRegisterType())
                || RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType())){
            //银行所在地区-香港
            bankArea = new HashMap<>();
            bankArea.put("bankAreaType",BankAreaType.HONG_KONG.name());
            bankArea.put("bankAreaDesc", BankAreaType.HONG_KONG.getDesc());
            bankAreaList.add(bankArea);
        }

        //初始化银行所在地区-结束

        //初始化币种-开始
        for(SiteEnum siteEnum : SiteEnum.values()){
            currencyWbMap = new HashMap<>();
            currencyWbMap.put("currencyKyc",siteEnum.getCurrency());
            currencyWbMap.put("currency",siteEnum.getCurrency() + "/" + siteEnum.getHyDesc());
            currencyWbList.add(currencyWbMap);
        }
        currencyCNYMap.put("currencyKyc",CommonConstant.TRADE_CURRENCY_CNY);
        currencyCNYMap.put("currency",CommonConstant.TRADE_CURRENCY_CNY + "/人民币");
        currencyCNYList.add(currencyCNYMap);
        //初始化币种-结束
        //初始化戶名-开始
        JSONObject jsonObject = apiSunrateTradePriceService.findCertiInfo(kycNaturalVO.getId(), kycNaturalVO.getRegisterType());
        if(null == jsonObject){
            log.error("实名信息为空");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        if( RegisterType.MAINLAND_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            acctPersonalNameMap = new HashMap<>();
            acctPersonalNameMap.put("nameType",CommonConstant.TYPE_PERSONAL);
            acctPersonalNameMap.put("name",jsonObject.get("cusName"));
            currencyAcctPersonalList.add(acctPersonalNameMap);
        }else if(RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType())){
            acctPersonalNameMap = new HashMap<>();
            acctPersonalNameMap.put("nameType",CommonConstant.TYPE_PERSONAL);
            acctPersonalNameMap.put("name",jsonObject.get("legalRepresentativeName"));//法人名称
            currencyAcctPersonalList.add(acctPersonalNameMap);
            acctCompanyNameMap = new HashMap<>();
            acctCompanyNameMap.put("nameType",CommonConstant.TYPE_COMPANY);
            acctCompanyNameMap.put("name",jsonObject.get("companyName"));//公司名称
            currencyAcctCompanyList.add(acctCompanyNameMap);
        }else if( RegisterType.HK_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            acctPersonalNameMap = new HashMap<>();
            acctPersonalNameMap.put("nameType",CommonConstant.TYPE_PERSONAL);
            acctPersonalNameMap.put("name",jsonObject.get("cusName"));
            currencyAcctPersonalList.add(acctPersonalNameMap);
        }else if(RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType())){
            acctPersonalNameMap = new HashMap<>();
            acctPersonalNameMap.put("nameType",CommonConstant.TYPE_PERSONAL);
            acctPersonalNameMap.put("name",jsonObject.get("directorName"));//董事名称
            currencyAcctPersonalList.add(acctPersonalNameMap);
            acctCompanyNameMap = new HashMap<>();
            acctCompanyNameMap.put("nameType",CommonConstant.TYPE_COMPANY);
            acctCompanyNameMap.put("name",jsonObject.get("companyName"));//公司名称
            currencyAcctCompanyList.add(acctCompanyNameMap);
        }
        //初始化戶名-結束
        JSONObject jsonObjectResult = new JSONObject();
        jsonObjectResult.put("bankArea",bankAreaList);//银行所在地区
        jsonObjectResult.put("currencyWb",currencyWbList);//外幣币种
        jsonObjectResult.put("currencyCNY",currencyCNYList);//人民幣币种
        jsonObjectResult.put("acctPersonalName",currencyAcctPersonalList);//個人账户名
        jsonObjectResult.put("acctCompanyName",currencyAcctCompanyList);//企業账户名
        jsonObjectResult.put("acctCompanyType",companyAcctTypeList);//企业账户类型


        KycNaturalVO kycNaturalVOResult = jsKycNaturalService.findKycNaturalVO(kycNaturalVO);
        boolean recordFlag = null == kycNaturalVOResult || null == kycNaturalVOResult.getRecordFlag() ? false : kycNaturalVOResult.getRecordFlag();
        jsonObjectResult.put("recordFlag",recordFlag);//是否通过经营者备案[1是，0否]
        return ResultUtil.success(jsonObjectResult);
    }

    @Override
    public ResponseMessage addBankCard(KycBankReq kycBankReq, KycNaturalVO kycNaturalVO, HttpServletResponse response) {
        JSONObject jsonObject = apiSunrateTradePriceService.findCertiInfo(kycNaturalVO.getId(), kycNaturalVO.getRegisterType());
        boolean sunrateFlag;
        //参数校验
        ResponseMessage validResult = paramsValid(kycBankReq,kycNaturalVO,jsonObject);
        if(!validResult.isSuccess()){
            return validResult;
        }
        Map<String,Object> returnMap = (Map<String, Object>) validResult.getData();
        sunrateFlag = (boolean)returnMap.get("sunrateFlag");
        BankAcctTypeEnum bankAcctType = (BankAcctTypeEnum)returnMap.get("bankAcctType");
        String idNo = null == returnMap.get("idNo") ? "" : (String)returnMap.get("idNo");
        if(BankAcctTypeEnum.COMPANY_SELF.equals(bankAcctType) && !sunrateFlag){
            //银行卡四要素校验
            KycCheckBankReq kycCheckBankReq = new KycCheckBankReq();
            kycCheckBankReq.setAcctPan(kycBankReq.getAccountNo());//银行账号
            kycCheckBankReq.setAcctName(kycBankReq.getAccountName());//开户名称
            kycCheckBankReq.setCertId(idNo);
            kycCheckBankReq.setPhoneNum(kycBankReq.getPhone());
            kycCheckBankReq.setWayJdBankCheckEnum(WayJdBankCheckEnum.FOUR_ELEMENT);
            kycCheckBankReq.setUseReal(true);
            ResponseMessage responseMessage = this.checkBank(kycCheckBankReq);
            log.info("银行卡四要素校验结果：{}",responseMessage);
            if(!responseMessage.isSuccess()){
                return responseMessage;
            }
        }
        //校验验证码是否正确
        try {
            ValidateCodeReq validateCodeReq = regiserReqConvertToValidateCodeReq(kycBankReq);
            validateCodeProcessorHolder.findValidateCodeProcessor("sms").validate(validateCodeReq, response);
        } catch (ValidateCodeException exception) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),exception.getMessage());
        } catch (Exception e) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),ResultEnum.VALIDATE_CODE_ERROT.getMsg());
        }
        kycBankReq.setRouteType(sunrateFlag ? SysPlateformType.SUNRATE : SysPlateformType.HFGJ);
        kycBankReq.setCompanyAcctType(bankAcctType);
        kycBankReq.setIdNo(idNo);
        ResponseMessage responseMessageAdd = apiKycBankService.addBankCard(kycBankReq,kycNaturalVO);
        if(!responseMessageAdd.isSuccess()){
            return responseMessageAdd;
        }
        if(sunrateFlag){
            log.info("参数校验通过，绑卡提现渠道走寻汇，且受益人为源奉，已在提交实名信息时绑定，无需再次添加，提现时需要区别此类型需要主动打款操作");
            KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq = convertToKycSunrateBeneficiaryReq(kycBankReq,jsonObject,kycNaturalVO);
            if(null == kycSunrateBeneficiaryReq){
                log.error("组装寻汇添加受益人接口请求参数失败");
                return responseMessageAdd;
            }
            log.info("调用寻汇添加受益人入参：{}",JSON.toJSONString(kycSunrateBeneficiaryReq));
            ResponseMessage responseMessage = jsKycSunrateBeneficiaryService.beneficiaryCreate(kycSunrateBeneficiaryReq,kycNaturalVO);
            log.info("调用寻汇添加受益人结束-结果:{},{}",responseMessage.isSuccess(),responseMessage.getMsg());
        }else{
            log.info("参数校验通过，绑卡提现渠道走汇付，无需进行开户操作");
        }
        return responseMessageAdd;
    }

    private ResponseMessage paramsValid(KycBankReq kycBankReq,KycNaturalVO kycNaturalVO,JSONObject jsonObject){
        //币种校验
        if(!CommonConstant.TRADE_CURRENCY_CNY.equals(kycBankReq.getCurrencyCode()) && null == SiteEnum.getByCurrency(kycBankReq.getCurrencyCode())){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-币种不正确");
        }
        //是否调用寻汇标识，true走寻汇添加受益人，false表示走汇付开户
        boolean sunrateFlag = false;
        BankAcctTypeEnum bankAcctType = null;
        String idNo = "";
        //注册类型为香港个人时，校验swiftcode，并赋值sunrateFlag走寻汇通道
        if(RegisterType.HK_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            bankAcctType = BankAcctTypeEnum.COMPANY_SELF;
            if(StringUtils.isBlank(kycBankReq.getSwiftCode())){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-swiftcode不能为空");
            }
            sunrateFlag = true;
        }
        //注册类型为大陆个人时，校验bankCode
        if(RegisterType.MAINLAND_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            bankAcctType = BankAcctTypeEnum.COMPANY_SELF;
            idNo = jsonObject.getString("idNo");
            if(StringUtils.isBlank(kycBankReq.getBankCode())){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-银行Code不能为空");
            }
        }
        //当注册类型为大陆企业时
        if(RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType())){
            BankAcctTypeEnum companyAcctType = kycBankReq.getCompanyAcctType();
            //账户类型为必选择项，为空返回错误信息
            if(null == companyAcctType){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业请选择开户账户类型");
            }
            bankAcctType = companyAcctType;
            //当账户类型为对私时，校验外币情况
            if(BankAcctTypeEnum.COMPANY_SELF.equals(companyAcctType)){
                idNo = jsonObject.getString("legalRepresentativeIdNo");
                if(StringUtils.isBlank(kycBankReq.getBankCode())){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对私时银行Code不能为空");
                }
                String currencyCode = kycBankReq.getCurrencyCode();
                if(!CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对私时币种不能选择外币");
                }
            }
            //当账户类型选择对公时
            if(BankAcctTypeEnum.COMPANY_PUBLIC.equals(companyAcctType)){
                idNo = jsonObject.getString("unifiedSocialCreditCode");
                String currencyCode = kycBankReq.getCurrencyCode();
                //当对公类型选择人民币种时
                if(CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                    String provinceCode = kycBankReq.getProvinceCode();
                    if(StringUtils.isBlank(provinceCode)){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时省份编码不能为空");
                    }
                    String provinceName = kycBankReq.getProvinceName();
                    if(StringUtils.isBlank(provinceName)){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时省份名称不能为空");
                    }
                    String cityCode = kycBankReq.getCityCode();
                    if(StringUtils.isBlank(cityCode)){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时城市编码不能为空");
                    }
                    String cityName = kycBankReq.getCityName();
                    if(StringUtils.isBlank(cityName)){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时城市名称不能为空");
                    }
                    String bankBranchName = kycBankReq.getBankBranchName();
                    if(StringUtils.isBlank(bankBranchName)){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时支行名称不能为空");
                    }
                }else{
                    KycNaturalVO kycNaturalVOResult = jsKycNaturalService.findKycNaturalVO(kycNaturalVO);
                    boolean recordFlag = null == kycNaturalVOResult || null == kycNaturalVOResult.getRecordFlag() ? false : kycNaturalVOResult.getRecordFlag();
                    if(!recordFlag){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-大陆企业账户类型对公时因备案未通过不可以选择外币");
                    }
                    //当对公类型选择外币币种时
                    sunrateFlag = true;
                    if(StringUtils.isBlank(kycBankReq.getSwiftCode())){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-swiftcode不能为空");
                    }
                }
            }
        }
        //当注册类型为香港企业时
        if(RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType())){
            BankAcctTypeEnum companyAcctType = kycBankReq.getCompanyAcctType();
            //账户类型为必选择项，为空返回错误信息
            if(null == companyAcctType){
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-香港企业请选择开户账户类型");
            }
            bankAcctType = companyAcctType;
            //当账户类型为对私时，校验外币情况
            if(BankAcctTypeEnum.COMPANY_SELF.equals(companyAcctType)){
                idNo = jsonObject.getString("directorIdNo");
                if(StringUtils.isBlank(kycBankReq.getBankCode())){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-银行Code不能为空");
                }
                //对私时校验董事证件类型，只能为二代身份证件类型
                String directorIdType = null == jsonObject.get("directorIdType") ? "" : jsonObject.getString("directorIdType");
                if(!CertiFileType.ID_CARD.name().equals(directorIdType)){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-香港企业董事证件类型不正确");
                }
                String currencyCode = kycBankReq.getCurrencyCode();
                //当选择对私类型且选择币种不为人民币时提示错误信息
                if(!CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-香港企业账户类型对私时币种不能选择外币");
                }
            }
            //当账户类型选择对公时
            if(BankAcctTypeEnum.COMPANY_PUBLIC.equals(companyAcctType)){
                String currencyCode = kycBankReq.getCurrencyCode();
                //当对公类型选择人民币种时
                if(CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-香港企业账户类型对公时币种不能选择人民币");
                }else{
                    //当对公类型选择外币币种时
                    sunrateFlag = true;
                    if(StringUtils.isBlank(kycBankReq.getSwiftCode())){
                        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() +"-swiftcode不能为空");
                    }
                }
            }
        }
        Map<String,Object> returnMap = new HashMap<>();
        returnMap.put("sunrateFlag",sunrateFlag);
        returnMap.put("bankAcctType",bankAcctType);
        returnMap.put("idNo",idNo);
        return ResultUtil.success(returnMap);
    }

    private ValidateCodeReq regiserReqConvertToValidateCodeReq(KycBankReq kycBankReq){
        ValidateCodeReq validateCodeReq = new ValidateCodeReq();
        validateCodeReq.setMarkStr(kycBankReq.getMarkStr());
        validateCodeReq.setPhoneNo(kycBankReq.getPhone());
        validateCodeReq.setSmsCode(kycBankReq.getSmsCode());
        return validateCodeReq;
    }

    //封装请求寻汇添加受益人接口请求参数
    private KycSunrateBeneficiaryReq convertToKycSunrateBeneficiaryReq(KycBankReq kycBankReq,JSONObject jsonObject,KycNaturalVO kycNaturalVO){
        KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq = new KycSunrateBeneficiaryReq();
        String countryCode = "CN";//国家代码
        if(BankAreaType.HONG_KONG.equals(kycBankReq.getStateOrRegion())){
            countryCode = "HK";
        }
        kycSunrateBeneficiaryReq.setCountryCode(countryCode);//国家代码
        kycSunrateBeneficiaryReq.setBankName(kycBankReq.getBankName());
        kycSunrateBeneficiaryReq.setRouteType("3");
        kycSunrateBeneficiaryReq.setSwiftcode(kycBankReq.getSwiftCode());
        kycSunrateBeneficiaryReq.setBeneficiaryName(kycBankReq.getAccountName());//受益人名称
        kycSunrateBeneficiaryReq.setBeneficiaryAcctNo(kycBankReq.getAccountNo());//受益人账号
        kycSunrateBeneficiaryReq.setCur(kycBankReq.getCurrencyCode());
        kycSunrateBeneficiaryReq.setRemark("添加受益人bank");
        kycSunrateBeneficiaryReq.setBeneficiaryType(BeneficiaryTypeEnum.JS_USER);
        if( RegisterType.HK_PERSONAL.equals(kycNaturalVO.getRegisterType())){
            kycSunrateBeneficiaryReq.setOrgCode(jsonObject.getString("certificateNo"));//orgCode取值-证件号
            kycSunrateBeneficiaryReq.setBeneficiaryAddr(jsonObject.getString("address"));//受益人地址取香港个人地址
        }else if(RegisterType.HK_COMPANY.equals(kycNaturalVO.getRegisterType())){
            kycSunrateBeneficiaryReq.setOrgCode(jsonObject.getString("companyRegisteredCertificateNo"));//orgCode取值-公司注册证书编号
            kycSunrateBeneficiaryReq.setBeneficiaryAddr(jsonObject.getString("companyAddress"));//受益人地址取香港企业公司经营地址
        }else if(RegisterType.MAINLAND_COMPANY.equals(kycNaturalVO.getRegisterType())){
            if(BankAcctTypeEnum.COMPANY_PUBLIC.equals(kycBankReq.getCompanyAcctType())) {
                kycSunrateBeneficiaryReq.setOrgCode(jsonObject.getString("unifiedSocialCreditCode"));//orgCode取值-统一社会信用代码
                kycSunrateBeneficiaryReq.setBeneficiaryAddr(jsonObject.getString("companyAddress"));//受益人地址取大陆企业公司经营地址
            }else{
                log.info("大陆企业对私类型暂不支持提现外币:{}",kycBankReq.getCompanyAcctType());
                return null;
            }
        }else{
            log.info("注册类型不符合:{}",kycNaturalVO.getRegisterType());
            return null;
        }
        return kycSunrateBeneficiaryReq;
    }

    @Override
    public ResponseMessage getProvence() {
        return apiKycBankService.getProvence();
    }

    @Override
    public ResponseMessage getCity(String provinceCode) {
        return apiKycBankService.getCity(provinceCode);
    }

    @Override
    public ResponseMessage disableBankCard(KycBankDeleteReq kycBankDeleteReq, KycNaturalVO kycNaturalVO,HttpServletResponse response) {
        //校验验证码是否正确
        try {
            KycBankReq kycBankReq = new KycBankReq();
            kycBankReq.setMarkStr(kycBankDeleteReq.getMarkStr());
            kycBankReq.setPhone(kycBankDeleteReq.getPhone());
            kycBankReq.setSmsCode(kycBankDeleteReq.getSmsCode());
            ValidateCodeReq validateCodeReq = regiserReqConvertToValidateCodeReq(kycBankReq);
            validateCodeProcessorHolder.findValidateCodeProcessor("sms").validate(validateCodeReq, response);
        } catch (ValidateCodeException exception) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),exception.getMessage());
        } catch (Exception e) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),ResultEnum.VALIDATE_CODE_ERROT.getMsg());
        }
        return apiKycBankService.disableBankCard(kycBankDeleteReq.getBankId(),kycNaturalVO);
    }

    @Override
    public ResponseMessage checkBank(KycCheckBankReq kycCheckBankReq) {
        return apiKycBankService.checkBank(kycCheckBankReq);
    }

    @Override
    public ResponseMessage findJsBankList(String bankCode) {
        return apiJsBankService.findJsBankList(bankCode);
    }
}
