package com.js.web.controller.vat;

import com.js.common.constant.Constant;
import com.js.common.enums.RegisterType;
import com.js.common.enums.VatPayStationTypeEnum;
import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.req.KycShowStoreReq;
import com.js.common.model.req.ValidateCodeReq;
import com.js.common.model.vo.JsPayVatPaymentInfoVO;
import com.js.common.model.vo.JsPayVatSubAcctInfoVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import com.js.web.service.JsPayVatPaymentInfoService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
@Slf4j
public class JsPayVatPaymentController {

    @Autowired
    private JsPayVatPaymentInfoService jsPayVatPaymentInfoService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;
    /**
     * vat 缴税收款人列表
     * @Author liwm
     * @Date 2019/6/27
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsVatPayment/queryRcvList")
    public ResponseMessage queryRcvList(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return  jsPayVatPaymentInfoService.queryRcvList(optionalKycNaturalVO.get().getId());
    }

    /**
     * vat 协议是否展示
     * @Author liwm
     * @Date 2019/6/27
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsVatPayment/queryTreaty")
    public ResponseMessage queryTreaty(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        String kycNaturalId = optionalKycNaturalVO.get().getId();
        return  jsPayVatPaymentInfoService.queryTreaty(kycNaturalId);
    }

    /**
     * vat 协议展示确认
     * @Author liwm
     * @Date 2019/6/27
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsVatPayment/submitTreaty")
    public ResponseMessage submitTreaty(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        String kycNaturalId = optionalKycNaturalVO.get().getId();
        return  jsPayVatPaymentInfoService.submitTreaty(kycNaturalId);
    }

    /**
     * js我的店铺列表
     * @Author liwm
     * @Date 2019/7/2
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsVatPayment/storeList")
    public ResponseMessage storeList(@RequestBody KycShowStoreReq kycShowStoreReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        kycShowStoreReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsPayVatPaymentInfoService.storeList(kycShowStoreReq);
    }

    /**
     * vat 缴税 确认缴税
     * @Author liwm
     * @Date 2019/6/28
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsVatPayment/payVatPayment")
    public ResponseMessage payVatPayment(@Valid @RequestBody JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        KycNaturalVO kycNaturalVO = optionalKycNaturalVO.get();
        jsPayVatPaymentInfoReq.setKycNaturalId(kycNaturalVO.getId());
        jsPayVatPaymentInfoReq.setKycNaturalName(kycNaturalVO.getCertificationName());
        jsPayVatPaymentInfoReq.setPhone(kycNaturalVO.getPhoneNo());
        return  jsPayVatPaymentInfoService.payVatPayment(jsPayVatPaymentInfoReq,optionalKycNaturalVO.get());
    }

    /**
     * vat 缴税 验证码生成
     * @Author liwm
     * @Date 2019/7/18
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/jsVatPayment/{type}/getSmsCode")
    public ResponseMessage getSmsCode(@PathVariable String type,@RequestBody ValidateCodeReq validateCodeReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        return  jsPayVatPaymentInfoService.getSmsCode(type,validateCodeReq,  response);
    }

    /**
     * vat 缴税 test
     * @Author liwm
     * @Date 2019/6/28
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsVatPayment/getPayVatPayment")
    public ResponseMessage getPayVatPayment() throws Exception{
        JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq = new JsPayVatPaymentInfoReq();
        jsPayVatPaymentInfoReq.setBrowserIP("192.168.1.16");
//        jsPayVatPaymentInfoReq.setKycNaturalId("121d7c3b3e2644b5ba1245e554e74340");
//        jsPayVatPaymentInfoReq.setKycNaturalName("缴税人老王");
        jsPayVatPaymentInfoReq.setCusName("英税局账户名称");
//        jsPayVatPaymentInfoReq.setIban("232525435345345345345");
        jsPayVatPaymentInfoReq.setSortCode("412827199202221543");
        jsPayVatPaymentInfoReq.setBankBic("BKCHCNBJ110");
        jsPayVatPaymentInfoReq.setRouteType("3");
        jsPayVatPaymentInfoReq.setBankCardNo("23252543534235345345345");
        jsPayVatPaymentInfoReq.setBankName("环球银行大陆分行");
        jsPayVatPaymentInfoReq.setTaxStationCountry("UK");
        jsPayVatPaymentInfoReq.setVatPayCur("GBP");
        jsPayVatPaymentInfoReq.setTaxStationId("");
        jsPayVatPaymentInfoReq.setTaxStationName("英国税务局");
        jsPayVatPaymentInfoReq.setTaxStationType(VatPayStationTypeEnum.TAX_STATION);
        jsPayVatPaymentInfoReq.setBeneficiaryId("");  // 1907041310
        jsPayVatPaymentInfoReq.setVatRegisteNo("asd234234");
        jsPayVatPaymentInfoReq.setPhone("13412365789");

        jsPayVatPaymentInfoReq.setMarkStr("假数据");
        jsPayVatPaymentInfoReq.setSmsCode("code");


        JsPayVatSubAcctInfoVO subAcctNoVO = new JsPayVatSubAcctInfoVO();
        subAcctNoVO.setStoreId("8f6bcdb5e5ea4ee9b215d138dd3904bd");
        subAcctNoVO.setPayAmt(new BigDecimal("33.50"));
        subAcctNoVO.setPayCur("GBP");
        subAcctNoVO.setSubAcctNo("1234");
        List<JsPayVatSubAcctInfoVO> subAcctNoList = new ArrayList<>();
        subAcctNoList.add(subAcctNoVO);
        jsPayVatPaymentInfoReq.setSubAcctNoInfoList(subAcctNoList);

//        jsPayVatPaymentInfoReq.
        KycNaturalVO kycNaturalVO = new KycNaturalVO();
        kycNaturalVO.setId("b2c88751c4524d2881178ddaecee930c");
        kycNaturalVO.setCreateId("b2c88751c4524d2881178ddaecee930c");
        kycNaturalVO.setCertificationName("测试者张三");
        kycNaturalVO.setRegisterType(RegisterType.MAINLAND_COMPANY);
        return  jsPayVatPaymentInfoService.payVatPayment(jsPayVatPaymentInfoReq, kycNaturalVO);
//        return  jsPayVatPaymentInfoService.addVatPayTradeForNoPass(jsPayVatPaymentInfoReq);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsVatPayment/queryVatList")
    public ResponseMessage queryVatList(){
        ResponseMessage status = jsPayVatPaymentInfoService.queryVatList();
        List<JsPayVatPaymentInfoVO> list = (List<JsPayVatPaymentInfoVO>)status.getData();
        for(JsPayVatPaymentInfoVO vo: list){
            vo.getStatus().keyName();
        }
        System.out.println(status.getData());
        return status;
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsVatPayment/estVatChinaPNRTransaction")
    public ResponseMessage estVatChinaPNRTransaction(){
        ResponseMessage status = jsPayVatPaymentInfoService.testVatChinaPNRTransaction();

        return status;
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsVatPayment/submitTransactionDetails")
    public ResponseMessage submitTransactionDetails(String batchNo){
        ResponseMessage status = jsPayVatPaymentInfoService.submitTransactionDetails(batchNo);
        return status;
    }
}
