package com.js.web.controller.swagger;

import com.js.common.constant.Constant;
import com.js.common.model.req.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.ChinapnrPaySerivce;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.Map;

/**
 * 汇付国际支付接口支付
 */
@Api(value="汇付国际",tags="汇付国际")
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class ChinapnrPaySwaggerController {

    @Autowired
    private ChinapnrPaySerivce chinapnrPaySerivce;


    @ApiOperation(value="个人开户",notes="个人开户")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/account/personal",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage opendAccountPersonal(@Valid @RequestBody ChinaPNRPersonalOpenAccountReq chinaPNRPersonalOpenAccountReq){
        return chinapnrPaySerivce.opendAccountPersonal(chinaPNRPersonalOpenAccountReq);
    }

    @ApiOperation(value="企业开户",notes="企业开户")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/account/enterprise",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage opendAccountEnterprise(@Valid @RequestBody ChinaPNREnterpriseOpenAccountReq chinaPNREnterpriseOpenAccountReq){
        return chinapnrPaySerivce.opendAccountEnterprise(chinaPNREnterpriseOpenAccountReq);
    }

    @ApiOperation(value="旧版代发",notes="还款（本金，利息）、汇差、服务费")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/account/substituteOld",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage substituteOld(@Valid @RequestBody ChinaPNRSubstituteReq chinaPNRSubstituteReq){
        return chinapnrPaySerivce.substituteOld(chinaPNRSubstituteReq);
    }

    @ApiOperation(value="新版代发",notes="提现")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/account/substituteNew",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage substituteNew(@Valid @RequestBody ChinaPNRSubstituteReq chinaPNRSubstituteReq){
        return chinapnrPaySerivce.substituteNew(chinaPNRSubstituteReq);
    }

    /**
     * 新版代发查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    @ApiOperation(value="新版代发查询",notes="新版代发查询")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/query/new",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage queryNewSubstitute(@Valid @RequestBody  ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq) {
        return chinapnrPaySerivce.queryNewSubstitute(chinaPNRSubstituteQueryReq);
    }

    /**
     * 旧版代发查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    @ApiOperation(value="旧版代发查询",notes="旧版代发查询")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/query/old",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage queryOldSubstitute(@Valid @RequestBody  ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq) {
        return chinapnrPaySerivce.queryOldSubstitute(chinaPNRSubstituteQueryReq);
    }

    /**
     * 个人开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    @ApiOperation(value="个人开户信息修改",notes="个人开户信息修改")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/update/personal",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage personalUpdateOpenAccount(@Valid @RequestBody  ChinaPNRPersonalOpenAccountReq chinaPNROpenAccountReq) {
        return chinapnrPaySerivce.personalUpdateOpenAccount(chinaPNROpenAccountReq);
    }

    /**
     * 企业开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    @ApiOperation(value="企业开户信息修改",notes="企业开户信息修改")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/update/enterprise",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage enterpriseUpdateOpenAccount(@Valid @RequestBody  ChinaPNREnterpriseOpenAccountReq chinaPNROpenAccountReq) {
        return chinapnrPaySerivce.enterpriseUpdateOpenAccount(chinaPNROpenAccountReq);
    }

    /**
     * 个人开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    @ApiOperation(value="个人开户信息查询",notes="个人开户信息查询")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/query/personal",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage personalQueryOpenAccount(@Valid @RequestBody  ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq) {
        return chinapnrPaySerivce.personalQueryOpenAccount(chinaPNRQueryOpenAccountReq);
    }

    /**
     * 企业开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    @ApiOperation(value="企业开户信息查询",notes="企业开户信息查询")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/query/enterprise",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage enterpriseQueryOpenAccount(@Valid @RequestBody  ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq) {
        return chinapnrPaySerivce.enterpriseQueryOpenAccount(chinaPNRQueryOpenAccountReq);
    }

}
