package com.js.web.controller.pay;

import com.js.api.jspay.service.ApiSunrateBeneficiaryService;
import com.js.common.constant.Constant;
import com.js.common.model.req.*;
import com.js.common.model.vo.common.ResponseMessage;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * @Author liuh
 * @Description 与寻汇调用前后端交互controller
 * @Date 2019/5/21
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE},
        consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsSunrateBeneficiaryController {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0
    )
    private ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;

    /**
     * 添加受益人
     * @Author liuh
     * @Date 2019/6/12
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/beneficiaryCreate")
    public ResponseMessage beneficiaryCreate(@Valid @RequestBody KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq){
        return apiSunrateBeneficiaryService.beneficiaryCreate(kycSunrateBeneficiaryReq,null);
    }
}
