package com.js.web.controller.loan;


import com.js.common.constant.Constant;
import com.js.common.model.req.JsLoanStatisticsInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.StatisticsInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * 向借贷系统提供用户相关信息
 *
 * @author liutianyu
 */
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE},
        consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class StatisticsInfoController {

    @Autowired
    StatisticsInfoService statisticsInfoService;

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/statisticsInfo/baseInfo/{kycNaturalId}")
    public ResponseMessage getBaseInfo(@PathVariable("kycNaturalId") String kycNaturalId){
        return statisticsInfoService.getBaseInfo(kycNaturalId);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/statisticsInfo/platform/statistics/{kycNaturalId}")
    public ResponseMessage getPlatformStatisticsInfo(@PathVariable("kycNaturalId") String kycNaturalId){
        return statisticsInfoService.getPlatformStatisticsInfo(kycNaturalId);
    }

    /**
     * 风控指标，运劳营能力
     *
     * @param kycNaturalId
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/statisticsInfo/platform/amazonRiskQuota/{kycNaturalId}")
    public ResponseMessage getAmazonRiskQuota(@PathVariable("kycNaturalId") String kycNaturalId){
        return statisticsInfoService.getAmazonRiskQuota(kycNaturalId);
    }

    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/statisticsInfo/platform/amazonDataAnalysisByStore/storeList")
    public ResponseMessage getStoreList(@RequestBody JsLoanStatisticsInfoReq jsLoanStatisticsInfoReq){
        return statisticsInfoService.getStoreList(jsLoanStatisticsInfoReq);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/statisticsInfo/platform/amazonDataAnalysisByStore/store/{storeId}")
    public ResponseMessage getStoreList(@PathVariable("storeId") String storeId){
        return statisticsInfoService.getStore(storeId);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/statisticsInfo/platform/amazonDataAnalysisByKyc/kycHis/{kycNaturalId}")
    public ResponseMessage getKycHis(@PathVariable("kycNaturalId") String kycNaturalId){
        return statisticsInfoService.getKycHis(kycNaturalId);
    }
}
