package com.js.web.controller.loan;

import com.js.common.constant.Constant;
import com.js.common.model.req.RepaymentLoanReq;
import com.js.common.model.req.RepaymentOperationReq;
import com.js.common.model.req.RepaymentTrialReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsLoanRepaymentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;


/**
 * @Author zhouyngsheng
 * @Description 还款controller
 * @Date 2019/8/1
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class LoanRepaymentController {

    @Autowired
    private JsLoanRepaymentService jsLoanRepaymentService;

    @Autowired
    JsKycNaturalService jsKycNaturalService;
    /**
     * 还款明细查询
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/repayment/detailed")
    public ResponseMessage detailed(@RequestParam(value = "loanNo",required = false) String loanNo){
        return jsLoanRepaymentService.detailed(loanNo);
    }

    /**
     * 用户贷款记录情况查询
     * 需还款记录查询
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/repayment/loanSituation",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage loanSituation(@Valid @RequestBody RepaymentLoanReq repaymentLoanReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        repaymentLoanReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsLoanRepaymentService.loanSituation(repaymentLoanReq);
    }

    /**
     * 还款操作
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/repayment/operation",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage operation(@Valid @RequestBody RepaymentOperationReq repaymentOperationReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        repaymentOperationReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsLoanRepaymentService.operation(repaymentOperationReq);
    }

    /**
     * 还款试算
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/repayment/trial",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage trial(@Valid @RequestBody RepaymentTrialReq repaymentTrialReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        repaymentTrialReq.setKycNaturalId(optionalKycNaturalVO.get().getId());
        return jsLoanRepaymentService.trial(repaymentTrialReq);
    }

    /**
     * 还款店铺账户查询
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/repayment/queryStoreAccount")
    public ResponseMessage queryStoreAccount(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsLoanRepaymentService.queryStoreAccount(optionalKycNaturalVO.get().getId());
    }

}
